<?php
$GLOBALS['THRIFT_ROOT'] = './thrift';

require_once $GLOBALS['THRIFT_ROOT'] . '/Thrift.php';
require_once $GLOBALS['THRIFT_ROOT'] . '/transport/TSocket.php';
require_once $GLOBALS['THRIFT_ROOT'] . '/protocol/TBinaryProtocol.php';
require_once $GLOBALS['THRIFT_ROOT'] . '/packages/flume/ThriftFlumeEventServer.php';

$transport = new TSocket($host = 'localhost', $port = '9091');
$protocol = new TBinaryProtocolAccelerated($transport);
$client = new ThriftFlumeEventServerClient($protocol, $protocol);

$transport->open();
$timestamp = intval(microtime(true) * 1000);

// log standard message
$client->append(new ThriftFlumeEvent(array(
	'priority' => Priority::INFO,
	'timestamp' => $timestamp,
	'body' => 'http://www.easy-coding.de/;100',
	'fields' => array(
		'cat' => 'ping'
	)
)));

// log structed message
require_once $GLOBALS['THRIFT_ROOT'] . '/protocol/TBinarySerializer.php';
require_once $GLOBALS['THRIFT_ROOT'] . '/packages/vector/vector_types.php';
$vector = new VectorSequence();
$vector->query = 'thrift server example';
$vector->targets = array(
	VectorTarget::THREAD => 100,
	VectorTarget::BOARD => 10
);
$vector->env = array(
	Vector::BROWSER => 'Firefox 3.5',
	Vector::OS => 'Ubuntu 10.10',
	Vector::GEO_REGION => 'de-16', // for berlin
);

$body = TBinarySerializer::serialize($vector);
$client->append(new ThriftFlumeEvent(array(
	'priority' => Priority::INFO,
	'timestamp' => $timestamp,
	'body' => $body,
	'fields' => array(
		'cat' => 'impression'
	)
)));

$transport->close();
