<?php
$GLOBALS['THRIFT_ROOT'] = './thrift';

require_once $GLOBALS['THRIFT_ROOT'] . '/Thrift.php';
require_once $GLOBALS['THRIFT_ROOT'] . '/transport/TSocket.php';
require_once $GLOBALS['THRIFT_ROOT'] . '/transport/TServerSocket.php';
require_once $GLOBALS['THRIFT_ROOT'] . '/transport/TTransportFactory.php';
require_once $GLOBALS['THRIFT_ROOT'] . '/protocol/TBinaryProtocol.php';
require_once $GLOBALS['THRIFT_ROOT'] . '/server/TForkingServer.php';

require_once $GLOBALS['THRIFT_ROOT'] . '/packages/flume/flume_types.php';
require_once $GLOBALS['THRIFT_ROOT'] . '/packages/flume/ThriftFlumeEventServer.php';

/**
 * thrift server to handle flume events
 *
 * @author	Torben Brodt <www.easy-coding.de>
 */
class FlumeHandler implements ThriftFlumeEventServerIf {

	/**
	 * public api call
	 * @implements ThriftFlumeEventServerIf
	 */
	public function append($evt) {
		$cat = $evt->fields['cat'];
		
		if(method_exists($this, $cat)) {
			$this->$cat($evt);
		} else {
			echo 'unknown method: '.$cat;
		}
	}

	/**
	 * public api call
	 * @implements ThriftFlumeEventServerIf
	 */
	public function close() {
		echo "close";
	}

	/**
	 * for debug purpose
	 */
	protected function ping($evt) {
		print_r($evt);
	}

	/**
	 * unserialize thrift object
	 */
	protected function impression($evt) {
		require_once $GLOBALS['THRIFT_ROOT'] . '/packages/vector/vector_types.php';
		require_once $GLOBALS['THRIFT_ROOT'] . '/protocol/TBinarySerializer.php';

		$instance = TBinarySerializer::deserialize($evt->body, 'VectorSequence');
		print_r($instance);
	}
}

$handler = new FlumeHandler();
$processor = new ThriftFlumeEventServerProcessor($handler);

// will run server on port 9090
$transport = new TServerSocket();
$outputTransportFactory = $inputTransportFactory = new TTransportFactory($transport);
$outputProtocolFactory = $inputProtocolFactory = new TBinaryProtocolFactory();

$server = new TForkingServer(
	$processor,
	$transport,
	$inputTransportFactory,
	$outputTransportFactory,
	$inputProtocolFactory,
	$outputProtocolFactory
);

header('Content-Type: application/x-thrift');
$server->serve();
