<?php
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 * @package thrift.protocol
 */

require_once $GLOBALS['THRIFT_ROOT'].'/transport/TMemoryBuffer.php';
require_once $GLOBALS['THRIFT_ROOT'].'/protocol/TBinaryProtocol.php';

/**
 * Utility class for serializing and deserializing
 * a thrift object using TBinaryProtocolAccelerated.
 */
class TBinarySerializer {

  public static function serialize($object) {
    $transport = new TMemoryBuffer();
    $class_name = function_exists('thrift_protocol_write_binary') ? 'TBinaryProtocolAccelerated' : 'TBinaryProtocol';
    $protocol = new $class_name($transport);
    $object->write($protocol);
    return $transport->getBuffer();
  }

  public static function deserialize($string_object, $class_name) {
    $processor = new $class_name();
    $transport = new TMemoryBuffer($string_object);
    $class_name = function_exists('thrift_protocol_write_binary') ? 'TBinaryProtocolAccelerated' : 'TBinaryProtocol';
    $protocol = new $class_name($transport);
    $processor->read($protocol);
    return $processor;
  }
}
