import java.awt.Button;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

/**
 * Dies ist die Start-Klasse des Programms. Es wird ein Anmeldedialog gezeigt.
 * 
 * @author mradicke
 */
public class LehvisGUI extends Frame {

	/**
	 * Der Standard-Konstruktor stellt ein Fenster mit dem Anmeldedialog dar.
	 */
	public LehvisGUI() {
		setTitle("Lehvis-Anmeldung");
		setSize(800, 400);
		setVisible(true);
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent evt) {
				System.exit(0);
			}
		});
		zeigeAnmeldeGUI();
	}

	/**
	 * Hier wird der Anmeldedialog erzeugt. Beim Klicken des Anmeldeknopfes wird
	 * der Benutzername und das Passwort an die Nutzerverwaltung gesendet und
	 * dort berprft. Bei Erfolg wird die bungsgruppenauswahl angezeigt. Bei
	 * Misserfolg wird ein weiterer Anmelde-Versuch unternommen.
	 */
	private void zeigeAnmeldeGUI() {
		setLayout(new GridLayout(6, 2));

		add(new Panel());
		add(new Label("Eingerichtet sind Benutzer \"Tutor1\""));
		add(new Panel());
		add(new Label("und \"Student1\" bis \"Student9\""));
		add(new Panel());
		add(new Label("jeweils mit gleichlautendem Passwort."));

		final TextField benutzerNameText = new TextField("Tutor1", 20);
		add(new Label("Benutzername:"));
		add(benutzerNameText);

		final TextField passwortText = new TextField("Tutor1", 20);
		passwortText.setEchoChar('*');
		add(new Label("Passwort:"));
		add(passwortText);

		final Label statusLabel = new Label("Falsche Eingabe!");
		statusLabel.setVisible(false);
		add(statusLabel);

		Button anmeldenButton = new Button("Anmelden");
		anmeldenButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				boolean erfolg = new Nutzerverwaltung().anmelden(
						benutzerNameText.getText(), passwortText.getText());
				if (erfolg) {
					setLayout(new GridLayout(1, 1));
					setTitle("Lehvis - angemeldeter Nutzer "
							+ Nutzerverwaltung.holeAngemeldeterNutzer()
									.holeVorname()
							+ " "
							+ Nutzerverwaltung.holeAngemeldeterNutzer()
									.holeName());
					removeAll();
					add(new UebungsverwaltungGUI(LehvisGUI.this));
					validate();
				} else {
					statusLabel.setVisible(true);
					benutzerNameText.setText("");
					passwortText.setText("");
				}
				validate();
			}
		});
		add(anmeldenButton);

		validate();
	}

	/**
	 * Die Start-Methode erzeugt eine neue LehvisGUI.
	 * @param args Eingabeparameter
	 */
	public static void main(String[] args) {
		new LehvisGUI();
	}

}
