
/*
Marko Poetzsch
Philipp Kraatz
Julia Raschick
Claudia Bohm
Erdinc Eryilmaz
 */

import java.util.ArrayList;
import java.util.List;

public class Uebungsverwaltung {
	
	private Uebungsgruppe ausgewaehlteUebungsgruppe;
	private List<Uebungsgruppe> uebungsgruppenListe;

	Uebungsverwaltung() {
		
		this.uebungsgruppenListe = ladeUebungsgruppenListe();
		
	}

	public void auswaehlen(Uebungsgruppe uebungsgruppe) {
		
		this.ausgewaehlteUebungsgruppe = uebungsgruppe;
		
	}

	public void eintragen(Student teilnehmer) throws Exception {
		
		if ((ausgewaehlteUebungsgruppe.holeKapazitaet() <= ausgewaehlteUebungsgruppe.holeTeilnehmerListe().size())) {
			
			throw new Exception("Es sind keine freien Pltze mehr vorhanden!");
			
		} else if (ausgewaehlteUebungsgruppe.holeStudiengangListe().contains(teilnehmer.holeStudiengang()) != true) {
			
			throw new Exception("Sie sind nicht berechtigt sich in diese Uebungsgruppe einzuschreiben! ");
			
		} else if (ausgewaehlteUebungsgruppe.holeTeilnehmerListe().contains(teilnehmer)) {
			
			throw new Exception("Sie sind bereits Teilnehmer der Uebungsgruppe!");
			
		} else ausgewaehlteUebungsgruppe.holeTeilnehmerListe().add(teilnehmer);
		
	}

	public void verschiebe(Student teilnehmer, Uebungsgruppe uebungsgruppe) throws Exception {
		
		if ((uebungsgruppe.holeKapazitaet() <= uebungsgruppe.holeTeilnehmerListe().size())) {
			
			throw new Exception("Es sind keine freien Pltze mehr vorhanden!");
			
		} else if (uebungsgruppe.holeStudiengangListe().contains(teilnehmer.holeStudiengang()) == false) {
			
			throw new Exception("Der Teilnehmer ist nicht berechtigt sich in diese Uebungsgruppe einzuschreiben! ");
			
		} else if (uebungsgruppe.holeTeilnehmerListe().contains(teilnehmer)) {
			
			throw new Exception("Der Teilnehmer ist bereits in der Uebungsgruppe eingeschrieben!");
			
		} else uebungsgruppe.holeTeilnehmerListe().add(teilnehmer);
		loesche(teilnehmer);
	}

	public void loesche(Student teilnehmer) {
		
		ausgewaehlteUebungsgruppe.holeTeilnehmerListe().remove(teilnehmer);
		
	}

	public Uebungsgruppe holeAusgewaehlteUebungsgruppe() {
		
		return ausgewaehlteUebungsgruppe;
		
	}

	public List<Uebungsgruppe> holeUebungsgruppenListe() {
		
		return uebungsgruppenListe;
		
	}

	public List<Uebungsgruppe> ladeUebungsgruppenListe() {
		
		List<List<String>> gruppe = new UebungsdatenSpeicher().holeUebungsgruppenDaten();
		
		List<Uebungsgruppe> Zwischenspeicher = new ArrayList<Uebungsgruppe>();
		
		Nutzerverwaltung nutzerverwaltung = new Nutzerverwaltung();
		
		for (int i = 0; i < gruppe.size(); i++) {
			
			List<String> studiengangListe = new ArrayList<String>();
			List<Student> teilnehmerListe = new ArrayList<Student>();
			
			int index = 0;
			
			while (gruppe.get(i).get(index).equals("Studiengang")) {
				
				studiengangListe.add(gruppe.get(i).get(index + 1));
				index += 2;
				
			}
			
			while (gruppe.get(i).get(index).equals("Student")) {
				
				teilnehmerListe.add((Student) nutzerverwaltung.holeNutzer(gruppe.get(i).get(index + 1)));
				index += 2;
				
			}
			
			Tutor tutor = (Tutor) nutzerverwaltung.holeNutzer(gruppe.get(i).get(index + 1));
			String vorlesung = gruppe.get(i).get(index + 2);
			String tag = gruppe.get(i).get(index + 3);
			String uhrzeit = gruppe.get(i).get(index + 4);
			String raum = gruppe.get(i).get(index + 5);
			int kapazitaet = Integer.parseInt(gruppe.get(i).get(index + 6));
			
			Uebungsgruppe uebungsgruppe = new Uebungsgruppe(vorlesung, tag, uhrzeit, raum, kapazitaet, studiengangListe, tutor, teilnehmerListe);
			
			Zwischenspeicher.add(uebungsgruppe);
			
		}
		
		return Zwischenspeicher;
		
	}
	
}
