#!/bin/bash

echo -e '\r\n  Backup Manager by oSteven\r\n'

echo -e '  ===============================\r\n'


read -p '  Bitte das Quellverzeichnis / die Quelldatei angeben: ' dir


if [ -z $dir ]; then

	echo -e '\r\n  Kein Quellverzeichnis / keine Quelldatei angegeben!\r\n'
	exit
	
else
	
	echo -e '\r\n  Quellverzeichnis/Datei gesetzt: ' $dir
	echo -e ''
fi


read -p '  Bitte das Zielverzeichnis angeben: ' tardir


if [ -z $tardir ]; then

	echo -e '\r\n  Kein Zielverzechnis angegeben!\r\n'
	exit
	
else

	echo -e '\r\n  Zielverzeichnis gesetzt: ' $tardir
	echo -e ''
fi



read -p '  Bitte das Dateiformat angeben (TAR/TAR.GZ): ' exportformart


if [ -z $exportformart ]; then

	echo -e '\r\n  Kein Dateiformat angegeben!\r\n'
	exit
	
else

	echo -e '\r\n  Dateiformat gesetzt gesetzt: ' $exportformart
	echo -e ''
fi


if [ -n $dir ]; then

	if [ -n $tardir ]; then
	
		if [ -n $exportformart ]; then
	
			exportfile=$tardir'backup_'`date +%d-%m-%Y-%H:%m`"."$exportformart
			
			tar cfv $exportfile $dir
			
			echo -e '\r\nBackup wurde erstellt: \r\n'

			echo -e '\r\nInput: ' $dir
			echo -e '\r\nOutput: ' $tardir
			echo -e '\r\nExport: ' $exportformart
			echo -e '\r\n\r\n';
			
			exit
	
		fi
		
	fi
	
fi
