#include <iostream>
#include "liste.h"
#include "knoten.h"

//Knoten
///////////////////////////////////////
template <class T>
Knoten<T>::Knoten()
{
}

template <class T>
Knoten<T>::~Knoten()
{
}


//AnfangsKnoten
///////////////////////////////////////
template <class T>
AnfangsKnoten<T>::AnfangsKnoten()
{
	next = new EndKnoten<T>;
	cout << "Objekt [AnfangsKnoten] erzeugt\n";
}

template <class T>
AnfangsKnoten<T>::~AnfangsKnoten()
{
}

template <class T>
Knoten<T>* AnfangsKnoten<T>::einfuegen(T *d)
{
	next = next->einfuegen(d);
	return this;
}

template <class T>
void AnfangsKnoten<T>::anzeigen()
{
	next->anzeigen();
}

template <class T>
void AnfangsKnoten<T>::entfernen(Knoten<T> *k)
{
	next->entfernen(this);	//Entferne erst alle Nachfolger (und die Daten)
	delete this;			//dann erst selber entfernen
	cout << "Speicher wieder freigegeben\n\n";
}


//EndKnoten
///////////////////////////////////////
template <class T>
EndKnoten<T>::EndKnoten()
{
	cout << "Objekt [EndKnoten] erzeugt\n";
}

template <class T>
EndKnoten<T>::~EndKnoten()
{
}

template <class T>
Knoten<T>* EndKnoten<T>::einfuegen(T *d)
{
	AllgemeinerKnoten<T>* daten = new AllgemeinerKnoten<T>(d, this);
	return daten;
}

template <class T>
void EndKnoten<T>::anzeigen()
{
	cout << "Das ist der Endknoten\n";
}

template <class T>
void EndKnoten<T>::entfernen(Knoten<T> *k)
{
	delete this;
}


//AllgemeinerKnoten
//////////////////////////////////////
template <class T>
AllgemeinerKnoten<T>::AllgemeinerKnoten(T *d, Knoten<T> *n) : daten(d), next(n)
{
	cout << "Objekt [AllgemeinerKnoten] erzeugt\n";
}

template <class T>
AllgemeinerKnoten<T>::~AllgemeinerKnoten()
{
}

template <class T>
Knoten<T>* AllgemeinerKnoten<T>::einfuegen(T *d)
{
	int ret = daten->vergleichen(d);
	switch(ret)
	{
	case 1:
		AllgemeinerKnoten<T> *dKnoten;
		dKnoten = new AllgemeinerKnoten<T>(d, this);
		return dKnoten;
	case -1:
		next = next->einfuegen(d);
		return this;
	}
	return this;
}

template <class T>
void AllgemeinerKnoten<T>::anzeigen()
{
	daten->anzeigen();
	next->anzeigen();
}

template <class T>
void AllgemeinerKnoten<T>::entfernen(Knoten<T> *k)
{
	dynamic_cast<AnfangsKnoten<T>*>(k)->setNext(next);
	delete this->daten;
	delete this;
	dynamic_cast<AnfangsKnoten<T>*>(k)->getNext()->entfernen(k);
}