#include <iostream>
#include "daten.h"
using namespace std;
#ifndef _KNOTEN_H
#define _KNOTEN_H

template <class T>
class Knoten
{
public:
	Knoten();
	virtual ~Knoten();
	
	virtual Knoten<T>* einfuegen(T *d) = 0;
	virtual void anzeigen() = 0;
	virtual void entfernen(Knoten<T> *k) = 0;
};

template <class T>
class AnfangsKnoten : public Knoten<T>
{
private:
	Knoten<T> *next;

public:
	AnfangsKnoten();
	~AnfangsKnoten();	//virtual da in Basisklasse virtual

	Knoten<T>* einfuegen(T *d);	//virtual da in Basisklasse virtual
	void anzeigen();	//virtual da in Basisklasse virtual
	Knoten<T>* getNext(){return next;}
	void setNext(Knoten<T> *k){next = k;}
	void entfernen(Knoten<T> *k);	//virtual da in Basisklasse virtual
};

template <class T>
class EndKnoten : public Knoten<T>
{
public:
	EndKnoten();
	~EndKnoten();	//virtual da in Basisklasse virtual

	Knoten<T>* einfuegen(T *d);	//virtual da in Basisklasse virtual
	void anzeigen();	//virtual da in Basisklasse virtual
	void entfernen(Knoten<T> *k);
};

template <class T>
class AllgemeinerKnoten : public Knoten<T>
{
private:
	T *daten;
	Knoten<T> *next;

public:
	AllgemeinerKnoten(T *d, Knoten<T> *n);
	~AllgemeinerKnoten();	//virtual da in Basisklasse virtual

	Knoten<T>* einfuegen(T *d);	//virtual da in Basisklasse virtual
	void anzeigen();	//virtual da in Basisklasse virtual
	void entfernen(Knoten<T> *k);
};

#endif