// fuer Textausgaben auf der Konsole:
#include <stdio.h>

// fuer Random
#include <stdlib.h>
#include <time.h>

// hier die notwendigen Includes - es genuegt glut.h einzubinden, da
// diese wiederum GL/gl.h und alle weiteren benoetigten Include-
// Dateien einbindet
#include <GL/glut.h>

// fuer Winkelberechnungen
#include <math.h>

// Fischklasse einbinden
#include "fisch.h"

// zum Einbinden von Texturen
#include "glbmp.h"

// Konfiguration
#define CAM_SPEED 1.75
#define CAM_ROTATE 0.05f

// Config
// Performance Test = 201 Fische = 10 FPS bei 640x360
const int anzahlFische = 7;
const int anzahlRaubfische = 1;

float angle=0.0, deltaAngle=0.0, deltaMove=0.0, ratio; // Fuer den Kameraflug
float x=0.0f,y=1.75f,z=5.0f; // Position des Betrachters
float lx=0.0f,ly=0.0f,lz=-1.0f; // Blickwinkel des Betrachters

int viewnummer=0; // Aktuelle View
bool updater=false; // Alternative Moeglichkeit eine View zu triggern

// Fuer die 2D Projektion des Cockpits (z.B. Framerate)
int w, h;

int frame=0, fpstime, timebase=0; // Framerate
char string[30]; // Hier wird die Framerate reingeschrieben 
				// (global, damit wir sie nicht bei jedem Frame neuberechnen muessen)

// Fischinstanzen
Fisch *fische[anzahlFische];

// Raubfischinstanzen
Fisch *raubfische[anzahlRaubfische];

// Environment Map Textur
static GLuint environment;

// Textur fuer die Pflanze
static GLuint pflanze;

// Funktionsprototypen
void drawAthmosphere(void);
void drawTischplatte(void);
void drawTischbein(float x, float y, float z);
void drawGlaskaefig(void);
void drawWasser(void);
void drawDecke(void);
void drawInnenboden(void);
void drawPflanze(void);