#include "Fisch.h"

// fuer Random
#include <stdlib.h>

// fuer Textausgaben auf der Konsole:
#include <stdio.h>

// hier die notwendigen Includes - es genuegt glut.h einzubinden, da
// diese wiederum GL/gl.h und alle weiteren benoetigten Include-
// Dateien einbindet
#include <GL/glut.h>

// fuer Winkelberechnungen
#include <math.h>

/**
 * Konstruktor
 * @param n -> Name des Fischs
 * @param x -> Startposition des Fischs (x-Achse)
 * @param y -> Startposition des Fischs (y-Achse)
 * @param z -> Startposition des Fischs (z-Achse)
 */
Fisch::Fisch(char *n, int x, int y, int z) 
{
	bool rand1, rand2, rand3;

	// Online Test: Neue Attribute
	this->bewegtsich = true;
	this->slowDead = false;
	this->slowmo = 0; // wir zur drehung inkrementiert

	name = n; // Name des Fischs

	// Position des Fisches
	fischposx=x;
	fischposy=y;
	fischposz=z;

	// Zufallszahlen die ueber die Richtung des Fischs entscheiden
	rand1 = rand()%2 == 0;
	rand2 = rand()%2 == 0;
	rand3 = rand()%2 == 0;

	// Zufaelliger Vektor
	fischvektorx=(((rand()%200)/1000.0)+0.03) * (rand1 ? -1 : 1);
	fischvektory=(((rand()%200)/1000.0)+0.05) * (rand2 ? -1 : 1);
	fischvektorz=(((rand()%200)/1000.0)+0.03) * (rand3 ? -1 : 1);

	// Individuelle Fischgeschwindigkeit
	fischspeed = rand()%100/(FISCHSPEED*1.0);
	triggerspeed = 0;

	// Drehe dich immer um die y-Ache um dein Ziel im Blick zu haben
	fischrotatex=0;
	fischrotatey=1;
	fischrotatez=0;

	// Winkel der Rotation
	fischrotate=0;

	// Leuchtmittel
	ambience = 0;

	// Boese?
	evil = false;

	// Lebt?
	lebendig = true;

	// Alle Nachbareinstellungen nullen
	resetNachbar();
}

//Aufgabe1
void Fisch::bewegungStop(void) 
{
	this->bewegtsich = !this->bewegtsich;
}

//Aufgabe3
void Fisch::moveUp(void) 
{
	fischposy = 13.5;
}

//Aufgabe4
void Fisch::die() 
{
	this->slowDead = true;
}


/**
 * Liefert den Normalenvektor aus einer Flaeche von 3 Punkten
 * @param *res -> double[3] Array mit x,y,z Koordinate
 * @param x1, y1, z1 -> 3D Punkt Nr. 1
 * @param x2, y2, z2 -> 3D Punkt Nr. 2
 * @param x3, y3, z3 -> 3D Punkt Nr. 3
 */
void Fisch::normalenVektor(float *res, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3) 
{
	float laenge;
	float v1x, v1y, v1z;
	float v2x, v2y, v2z;

	// Als Parameter erhalten wir 3 Punkte
	// Daraus machen wir 2 Vektoren
	v1x = x1-x3;
	v1y = y1-y3;
	v1z = z1-z3;

	v2x = x2-x3;
	v2y = y2-y3;
	v2z = z2-z3;

	// Wir erhalten 2 Vektoren
	// daraus errechnen wir das Kreuzprodukt
	res[0] = (v1y * v2z) - (v1z * v2y);  
	res[1] = (v1z * v2x) - (v1x * v2z);
	res[2] = (v1x * v2y) - (v1y * v2x);

	// Laenge ermitteln
	laenge = sqrt(pow(res[0], 2) + pow(res[1], 2) + pow(res[2], 2));

	// Auf Einheitsvektor bringen, indem wir durch Laenge teilen
	res[0] /= laenge;
	res[1] /= laenge;
	res[2] /= laenge;
}

/**
 * berechnet nach den 3 Regeln die neue Fischposition und setzt diese auch
 */
void Fisch::calculate(void) 
{
	if(!this->bewegtsich)
		return;

	float zentrumspeed, zentrumx, zentrumy, zentrumz;
	float tmpx, tmpy, tmpz;

	// Existieren Nachbarn? Wende Regeln an
	if(nachbarcount > 0) 
	{
		// Regel 3
		zentrumspeed = (nachbarspeed+fischspeed) / (nachbarcount+1);
		fischspeed = fischspeed + ((zentrumspeed-fischspeed)/REGEL3);


		// Regel 1 
		// Einschraenkung (wir bewegen uns nur ins zentrum, falls keine nachbarkollision auftritt)
		if(nachbarvektorx == 0 && nachbarvektory == 0 && nachbarvektorz == 0) {
			// Regel 1
			zentrumx = OUTSIDER ? nachbarzentrumx/nachbarcount : (nachbarzentrumx+fischposx)/(nachbarcount+1);
			zentrumy = OUTSIDER ? nachbarzentrumy/nachbarcount : (nachbarzentrumy+fischposy)/(nachbarcount+1);
			zentrumz = OUTSIDER ? nachbarzentrumz/nachbarcount : (nachbarzentrumz+fischposz)/(nachbarcount+1);
	
			fischvektorx = ((zentrumx - fischposx)/REGEL1)/fischspeed;
			fischvektory = ((zentrumy - fischposy)/REGEL1)/fischspeed;
			fischvektorz = ((zentrumz - fischposz)/REGEL1)/fischspeed;

		} else {
			// Regel 2
			// Wir teilen durch die Entfernung, weil wir so den Einheitsvektor bekommen - uns interessiert nur die Richtung
			float entfernung = this->entfernung(fischposx+nachbarvektorx, fischposy+nachbarvektory, fischposz+nachbarvektorz);

			fischvektorx -= (nachbarvektorx/entfernung)*REGEL2/100;
			fischvektory -= (nachbarvektory/entfernung)*REGEL2/100;
			fischvektorz -= (nachbarvektorz/entfernung)*REGEL2/100;
		}
	}

	// WO waeren wir denn, wenn wir die Bewegung machen wuerden?
	tmpx = fischposx + (fischvektorx*fischspeed);
	tmpy = fischposy + (fischvektory*fischspeed);
	tmpz = fischposz + (fischvektorz*fischspeed);

	// Verhindere Kollisionen mit den Waenden links und rechts
	if(tmpx < -13.5 || tmpx > 13.5) {
		fischvektorx *= -1;
	}

	// Verhindere Kollisionen mit den Waenden oben und unten
	if(tmpy < -13.5 || tmpy > 13.5) {
		fischvektory *= -1;

		// Sobald der Fisch oben angekommen ist, wird der Name auf tot gesetzt und die Bewegung deaktiviert
		if(slowDead) {
			bewegtsich = false;
			name = "tot";
		}
	}

	// Verhindere Kollisionen mit den Waenden vorne und hinten
	if(tmpz < -27 || tmpz > 27) {
		//fischvektorz += 0.1; fuehrt zum abprallen
		fischposy += 0.1;
	}

	// Drehe den Fisch nach Sinussatz in Flugrichtung
	float pythagoras = sqrt((fischvektorx*fischvektorx) + (fischvektorz*fischvektorz));
	float winkelbogenmass = acos(fischvektorz/pythagoras);
	winkelbogenmass *= fischvektorx > 0 ? 1 : -1;
	fischrotate = (winkelbogenmass * 180) / 3.14159265368979;

	// Fuehre die Bewegung tatsaechlich durch
	fischposx += fischvektorx*fischspeed;
	fischposy += fischvektory*fischspeed;
	fischposz += fischvektorz*fischspeed;

	// Schwimme nach oben
	if(this->slowDead) {
		if(fischposy<13.5) {
			fischposy+=0.2;
		}
	}
}

/**
 * Macht aus einem Fisch einen Raubfisch und umgekehrt
 * @param e -> true gdw der Fisch boese sein soll
 */
void Fisch::setEvil(bool e) 
{
	evil = e;
	fischspeed *= 10; // boese fische sind schneller
	fischvektorx *= 10;
	fischvektory *= 10;
	fischvektorz *= 10;
}

/**
 * Zeichenfunktion: Container zum kompletten Fisch
 */
void Fisch::display(void) 
{
	if(lebendig) 
	{
		glPushMatrix();
			if(slowDead) {
				/*	wirbel - das ist cool
					this->slowmo += 10;
					printf("dreh mich %f\n", this->slowmo);
					glRotatef(slowmo, 0, 0, 1);
				*/
			}

			this->drawFisch();
		glPopMatrix();
	
	} else if(ambience != 0) {
		//stirbt der Fisch, dann sollte das Licht noch deaktiviert werden
		glDisable(GL_LIGHT2);
	}
}

/**
 * Zeichenfunktion: Zeichnet den kompletten Fisch
 */
void Fisch::drawFisch(void) 
{
	glPushMatrix();

	// verschiebe das Zentrum des Fischs auf die errechnete Position
	glTranslatef(fischposx, fischposy, fischposz);

	// Drehe den Fisch in die errechnete Richtung
	glRotatef(fischrotate*1.0, fischrotatex, fischrotatey, fischrotatez);

	// Hier geschieht die Drehung des ganzen Fisches
	glPushMatrix();
	if(this->slowDead && this->slowmo < 90) {
		this->slowmo += 0.9;
		glRotatef(slowmo, 0, 0, 1);
	}

	// Soll der Fisch leuchten?
	if(ambience > 0) 
	{
		// Licht Konfiguration
		GLfloat light2_position[] = { 1.2, 1.2, 1.2, 1.0 };
		GLfloat light2_diffuse[] = { ambience*4, ambience*4, ambience*4, 1.0 };

		// Licht aktivieren
		glLightfv(GL_LIGHT2, GL_POSITION, light2_position);
		glLightfv(GL_LIGHT2, GL_DIFFUSE, light2_diffuse);
		glEnable(GL_LIGHT2);
	
	} else if(ambience < 0) {
		// Dies ist ein Workaround
		glDisable(GL_LIGHT2);
	}

	// Rumpf
	this->drawRumpf();

	// Flosse Rechts
	this->drawFlosse();

	// Flosse Links (gedreht)
	glPushMatrix();	
		glRotatef(180, 0, 0, 1);
		this->drawFlosse();
	glPopMatrix();

	// Schwanz
	this->drawSchwanz();

	// Text
	this->drawText();

	glPopMatrix();

	glPopMatrix();

}

/**
 * Zeichenfunktion fuer den Rumpf des Fisches (wird innerhalb von drawFisch aufgerufen)
 */
void Fisch::drawRumpf(void) 
{
	// Hier schreiben wir die Normalenvektoren x,y,z rein
	float tmp[3];

	// Der boese Fisch sieht anders aus
	if(this->evil) {
		glColor3f(0.3, 0, 0);
	} else if (this->ambience > 0) {
		glDisable(GL_COLOR_MATERIAL);
		GLfloat emission[] = { 0.5*this->ambience, 1*this->ambience , 0.5*this->ambience , 0 };
		glMaterialfv( GL_FRONT , GL_EMISSION, emission);
	} else {
		glColor3f(0, 1, 0);
	}

	this->normalenVektor(tmp,  -1, 0, 1, 0, -1, 1, 0, -0.2, 2); glNormal3fv(tmp);
	glBegin(GL_TRIANGLE_FAN);
		// Nasenspitze unten links
		glVertex3f(0, -1, 1); //2 face: mitte unten
		glVertex3f(-1, 0, 1); //1 face: links mitte
		glVertex3f(0, -0.2, 2); //7 face: nasenspitze
	glEnd();
		
	this->normalenVektor(tmp,  0, 1, 1, -1, 0, 1, 0, -0.2, 2); glNormal3fv(tmp);
	glBegin(GL_TRIANGLE_FAN);
		// Nasenspitze oben links
		glVertex3f(0, 1, 1); //0 face: mitte rechts
		glVertex3f(-1, 0, 1); //1 face: links mitte
		glVertex3f(0, -0.2, 2); //7 face: nasenspitze
	glEnd();
		
	this->normalenVektor(tmp,  1, 0, 1, 0, 1, 1, 0, -0.2, 2); glNormal3fv(tmp);
	glBegin(GL_TRIANGLE_FAN);
		// Nasenspitze oben rechts
		glVertex3f(0, 1, 1); //0 face: mitte rechts
		glVertex3f(1, 0, 1); //3 face: rechts mitte
		glVertex3f(0, -0.2, 2); //7 face: nasenspitze
	glEnd();
		
	this->normalenVektor(tmp,  0, -1, 1, 1, 0, 1,  0, -0.2, 2); glNormal3fv(tmp);
	glBegin(GL_TRIANGLE_FAN);
		// Nasenspitze unten rechts
		glVertex3f(1, 0, 1); //3 rechts mitte
		glVertex3f(0, -1, 1); //2 face: unten mitte
		glVertex3f(0, -0.2, 2); //7 face: nasenspitze
	glEnd();

	if(this->evil) {
		glColor3f(0, 0, 0);
	} else if (this->ambience > 0) {
		GLfloat emission[] = { 0.5*this->ambience, 0.5*this->ambience , 1*this->ambience , 0 };
		glMaterialfv( GL_FRONT , GL_EMISSION, emission);
	} else {
		glColor3f(0, 0, 1);
	}

	this->normalenVektor(tmp,  0, 1, 1,  -0.5, 0.5, -1.5, 0.5, 0.5, -1.5); glNormal3fv(tmp);
	glBegin(GL_TRIANGLE_FAN);
		// zentral oben
		glVertex3f(0, 1, 1); //0 face: mitte rechts
		glVertex3f(-0.5, 0.5, -1.5); //4
		glVertex3f(0.5, 0.5, -1.5); //5
	glEnd();
		
	this->normalenVektor(tmp,  0, 1, 1,  -1, 0, 1, -0.5, 0.5, -1.5); glNormal3fv(tmp);
	glBegin(GL_TRIANGLE_FAN);
		// links unten
		glVertex3f(0, 1, 1); //0
		glVertex3f(-1, 0, 1); //1
		glVertex3f(-0.5, 0.5, -1.5); //4
	glEnd();
		
	this->normalenVektor(tmp,  1, 0, 1,  0, 0, -1.5, 0.5, 0.5, -1.5); glNormal3fv(tmp);
	glBegin(GL_TRIANGLE_FAN);
		// rechts unten
		glVertex3f(1, 0, 1); //3
		glVertex3f(0, 0, -1.5); //6
		glVertex3f(0.5, 0.5, -1.5); //5
	glEnd();
	
	this->normalenVektor(tmp,  0, 1, 1, 1, 0, 1, 0.5, 0.5, -1.5); glNormal3fv(tmp);
	glBegin(GL_TRIANGLE_FAN);
		// rechts oben
		glVertex3f(1, 0, 1); //3
		glVertex3f(0, 1, 1); //0
		glVertex3f(0.5, 0.5, -1.5); //5
	glEnd();	
	
	this->normalenVektor(tmp,  1, 0, 1,  0, 0, -1.5, 0.5, 0.5, -1.5); glNormal3fv(tmp);
	glBegin(GL_TRIANGLE_FAN);
		// rechts unten
		glVertex3f(1, 0, 1); //3
		glVertex3f(0, 0, -1.5); //6
		glVertex3f(0.5, 0.5, -1.5); //5
	glEnd();
	
	this->normalenVektor(tmp,  0, 0, -1.5, -1, 0, 1, -0.5, 0.5, -1.5); glNormal3fv(tmp);
	glBegin(GL_TRIANGLE_FAN);
		// links unten hinten
		glVertex3f(-1, 0, 1); //1
		glVertex3f(0, 0, -1.5); //6
		glVertex3f(-0.5, 0.5, -1.5); //4
	glEnd();
		
	this->normalenVektor(tmp,  -0.5, 0.5, -1.5,  0, 0, -1.5, 0.5, 0.5, -1.5); glNormal3fv(tmp);
	glBegin(GL_TRIANGLE_FAN);
		// Arsch
		glVertex3f(-0.5, 0.5, -1.5); //4
		glVertex3f(0, 0, -1.5); //6
		glVertex3f(0.5, 0.5, -1.5); //5
	glEnd();
		
	this->normalenVektor(tmp,  1, 0, 1, 0, -1, 1,  0, 0, -1.5); glNormal3fv(tmp);
	glBegin(GL_TRIANGLE_FAN);
		// Bauch rechts
		glVertex3f(0, -1, 1); //2 face: unten mitte
		glVertex3f(1, 0, 1); //3
		glVertex3f(0, 0, -1.5); //6
	glEnd();
		
	this->normalenVektor(tmp,  0, -1, 1,  -1, 0, 1, 0, 0, -1.5); glNormal3fv(tmp);
	glBegin(GL_TRIANGLE_FAN);
		// Bauch links
		glVertex3f(0, -1, 1); //2 face: unten mitte
		glVertex3f(-1, 0, 1); //1
		glVertex3f(0, 0, -1.5); //6
	glEnd();

	if(this->ambience > 0) {
		glEnable(GL_COLOR_MATERIAL);
	}
}

/**
 * Zeichenfunktion fuer EINE seitliche Flosse 
 *		(wird innerhalb von drawFisch fuer jede Seite aufgerufen)
 */
void Fisch::drawFlosse(void) 
{
	// Hier schreiben wir die Normalenvektoren x,y,z rein
	float tmp[3];
	glPushMatrix();	

	// Transformationen
	glTranslatef(1, 0, 1);
	glScalef(0.5, 0.5, 1);
	glRotatef(45.84, 0, 1, 0);

	// Farbe
	glColor3f(1, 0, 0);

	this->normalenVektor(tmp,  0, 0, 0,  1, 0.5, 0, 1, -0.5, 0); glNormal3fv(tmp);
	glBegin(GL_TRIANGLE_FAN);
		// Front
		glVertex3f(0, 0, 0); //0 vorne links
		glVertex3f(1, 0.5, 0); //1 vorne rechts oben
		glVertex3f(1, -0.5, 0); //2 vorne rechts unten
	glEnd();

	this->normalenVektor(tmp,  0, 0, 0,  1, 0.5, 0, 0, 0, -0.1); glNormal3fv(tmp);
	glBegin(GL_TRIANGLE_FAN);
		// Oben
		glVertex3f(0, 0, 0); //0 vorne links
		glVertex3f(1, 0.5, 0); //1 vorne rechts oben
		glVertex3f(0, 0, -0.1); //3 zentral hinten
	glEnd();

	this->normalenVektor(tmp,  1, -0.5, 0,  1, 0.5, 0, 0, 0, -0.1); glNormal3fv(tmp);
	glBegin(GL_TRIANGLE_FAN);
		// Rechts
		glVertex3f(1, -0.5, 0); //2 vorne rechts unten
		glVertex3f(1, 0.5, 0); //1 vorne rechts oben
		glVertex3f(0, 0, -0.1); //3 zentral hinten
	glEnd();

	this->normalenVektor(tmp,  1, -0.5, 0,  0, 0, 0, 0, 0, -0.1); glNormal3fv(tmp);
	glBegin(GL_TRIANGLE_FAN);
		// Oben
		glVertex3f(1, -0.5, 0); //2 vorne rechts unten
		glVertex3f(0, 0, 0); //0 vorne links
		glVertex3f(0, 0, -0.1); //3 zentral hinten
	glEnd();
	glPopMatrix();
}

/**
 * Schwanzflosse des Fischs
 *		(wird innerhalb von drawFisch aufgerufen)
 */
void Fisch::drawSchwanz(void) 
{
	float tmp[3];
	glPushMatrix();	

	// Transformationen
	glTranslatef(0,0.5,-1.5);
	glScalef(0.5, 0.5, 0.5);

	// Farbe
	glColor3f(1, 0, 0);

	this->normalenVektor(tmp,  0, 0, 0,  -0.2, 2, -1, -0.2, -3, -1.4); glNormal3fv(tmp);
	glBegin(GL_TRIANGLE_FAN);
		// links aussen
		glVertex3f(0, 0, 0); //0 vorne oben
		glVertex3f(-0.2, 2, -1); //2 hinten oben links
		glVertex3f(-0.2, -3, -1.4); //4 hinten unten links
		glVertex3f(0, -1, 0); //1 vorne unten
	glEnd();

	this->normalenVektor(tmp,  0, 0, 0,  0.2, 2, -1, 0.2, -3, -1.4); glNormal3fv(tmp);
	glBegin(GL_TRIANGLE_FAN);
		// rechts aussen
		glVertex3f(0, 0, 0); //0 vorne oben
		glVertex3f(0.2, 2, -1); //3 hinten oben rechts
		glVertex3f(0.2, -3, -1.4); //5 hinten unten rechts
		glVertex3f(0, -1, 0); //1 vorne unten
	glEnd();

	this->normalenVektor(tmp,  0, -1, 0,  0.2, -3, -1.4, -0.2, -3, -1.4); glNormal3fv(tmp);
	glBegin(GL_TRIANGLE_FAN);
		// unten
		glVertex3f(0, -1, 0); //1 vorne unten
		glVertex3f(0.2, -3, -1.4); //5 hinten unten rechts
		glVertex3f(-0.2, -3, -1.4); //4 hinten unten links
	glEnd();

	this->normalenVektor(tmp,  0, 0, 0,  -0.2, 2, -1, 0.2, 2, -1); glNormal3fv(tmp);
	glBegin(GL_TRIANGLE_FAN);
		// oben
		glVertex3f(0, 0, 0); //0 vorne oben
		glVertex3f(-0.2, 2, -1); //2 hinten oben links
		glVertex3f(0.2, 2, -1); //3 hinten oben rechts
	glEnd();

	this->normalenVektor(tmp,  -0.2, 2, -1,  0.2, 2, -1, 0.2, -3, -1.4); glNormal3fv(tmp);
	glBegin(GL_TRIANGLE_FAN);
		// hinten
		glVertex3f(-0.2, 2, -1); //2 hinten oben links
		glVertex3f(0.2, 2, -1); //3 hinten oben rechts
		glVertex3f(0.2, -3, -1.4); //5 hinten unten rechts
		glVertex3f(0.2, -3, -1.4); //5 hinten unten links
	glEnd();

	glPopMatrix();
}

/**
 * Zeichenfunktion fuer den Namen des Fisches
 */
void Fisch::drawText(void) 
{
	// Text
	glPushMatrix();
		char *c;
		glRasterPos3f(0, 1, 1.5);
		for (c=name; *c != '\0'; c++) {
			glutBitmapCharacter((void*)GLUT_BITMAP_8_BY_13, *c);
		}
	glPopMatrix();
}

/**
 * Erhoeht die Helligkeit des Fisches
 */
void Fisch::powerUp(void) 
{
	ambience += ambience < 0.9 ? 0.1 : 0;
	printf("%s erhoeht seine Leuchtkraft auf %f\n", name, ambience);
}

/**
 * Vermindert die Helligkeit des Fisches
 */
void Fisch::powerDown(void) 
{
	ambience -= ambience > 0 ? 0.1 : 0;
	printf("%s vermindert seine Leuchtkraft auf %f\n", name, ambience);
}

/**
 * Berechnet die Entfernung des Fisches zur uebergebenen Koordinate
 * @param x -> X-Koordinate
 * @param y -> Y-Koordinate 
 * @param z -> Z-Koordinate
 */
float Fisch::entfernung(float x, float y, float z) 
{
	return sqrt(pow(fischposx-x, 2) + pow(fischposy-y, 2) + pow(fischposz-z, 2));
}

/**
 * setzt alle Daten ueber Nachbarn zurueck
 */
void Fisch::resetNachbar(void) 
{
	// Wieviele Nachbarn habe ich
	nachbarcount=0;

	// Summe aus allen Positionen meiner Nachbarn
	nachbarzentrumx=0;
	nachbarzentrumy=0;
	nachbarzentrumz=0;

	// Vektoren, falls mir ein Nachbar zu nahe kommt
	nachbarvektorx=0;
	nachbarvektory=0;
	nachbarvektorz=0;

	// Summe aus allen Nachbargeschwindigkeiten
	nachbarspeed=0;
}

/**
 * Liefert die Position des Fisches und schreibt sie in die uebergebenen Zeiger
 * @param x -> hier wird die x-Koordinate reingeschrieben
 * @param y -> hier wird die Y-Koordinate reingeschrieben
 * @param z -> hier wird die Z-Koordinate reingeschrieben
 */
void Fisch::getPos(float* x, float* y, float* z) 
{
	*x = fischposx;
	*y = fischposy;
	*z = fischposz;
}

/**
 * Raubfischmethode um uns ein Ziel zu geben
 */
void Fisch::addDest(float px, float py, float pz, float speed) 
{
	// Wir nehmen nur ein Ziel gleichzeitig war
	if(nachbarcount==0) 
	{
		++nachbarcount;

		// Nicht unbedingt eine Nachbarschaftsfreundschaft, 
		// aber zumindest das selbe Annaeherungsverhalten
		nachbarzentrumx+=px;
		nachbarzentrumy+=py;
		nachbarzentrumz+=pz;

		// Geschwindigkeit erhoehen
		nachbarspeed += 1;
	}
}

/**
 * Pruefe ob der Raubfisch in unmittelbarer Naehe ist
 * @param raubfisch -> Raubfisch Objekt
 */
void Fisch::checkRaubfisch(Fisch *raubfisch)
{
	if(lebendig) {
		// sag mir wie weit du von meiner Position weg bist
		float entfernung = raubfisch->entfernung(fischposx, fischposy, fischposz);

		if(entfernung < 2) 
		{
			printf("\n\nIch %s bin jetzt tot\n\n", name);
			lebendig = false;
			return;
		}

		if(entfernung < 14) 
		{
			// .. sage dem Hai wo ich bin - der nimmt Kurs auf mich
			raubfisch->addDest(fischposx, fischposy, fischposz, fischspeed);
		}

		// Jetzt sollte ich fliehen
		if(entfernung < 5) 
		{
			int r = rand()%20; // Fliehe nur in einem von 20 Faellen (bzw. Frames)
			if(r == 1)
				return;

			float haix, haiy, haiz;
			raubfisch->getPos(&haix, &haiy, &haiz);

			// Kollisionsregel erweitern - ich versuche zu fliehen
			nachbarvektorx -= fischposx-haix;
			nachbarvektory -= fischposy-haiy;
			nachbarvektorz -= fischposz-haiz;

			// Schneller werden muss der Fisch nicht unbedingt, 
			// dafuer sorgt schon der Vektor alleine

			++nachbarcount;
		}
	}
}

/**
 * Fuegt dem eigenen Fisch einen Nachbarn hinzu
 * @param entfernung -> entfernung zum nachbar
 * @param speed -> geschwindigkeit des nachbar
 * @param px -> Position des Nachbarn auf der x-Koordinate
 * @param py -> Position des Nachbarn auf der y-Koordinate
 * @param pz -> Position des Nachbarn auf der z-Koordinate
 */
void Fisch::addNachbar(float entfernung, float speed, float px, float py, float pz) 
{
	// Wir brauchen die Anzahl der Nachbarn um den Durchschnitt zu berechnen
	++nachbarcount;

	// Regel 1: Fliege ins Schwarmzentrum
	nachbarzentrumx+=px;
	nachbarzentrumy+=py;
	nachbarzentrumz+=pz;

	// Regel 2: Kollidiere nicht mit anderen
	if(entfernung < NACHBARKOLLISION) 
	{
		// Wenn wir die Position des Nachbarn von unserer eigenen Position
		// abziehen, dann entsteht der Richtungsvektor
		nachbarvektorx -= fischposx - px;
		nachbarvektory -= fischposy - py;
		nachbarvektorz -= fischposz - pz;
	}

	// Regel 3: Passe meine Geschwindigkeit dem Schwarm an
	nachbarspeed += speed;
}

/**
 * prueft ob sich der Fisch in unmittelbarer Naehe befindet 
 *		und fuegt diesen gegebenenfalls als Nachbar hinzu
 * @param nachbar -> Fisch Objekt
 */
void Fisch::checkNachbar(Fisch *nachbar) 
{
	if(!lebendig) // Wenn der Fisch tot ist, dann braucht er den anderen nichts mehr aufzuzwingen
		return;

	// sag mir wie weit du von meiner Position weg bist
	float entfernung = nachbar->entfernung(fischposx, fischposy, fischposz);

	if(entfernung < NACHBARNAEHE) 
	{
		// Wir sind der Chef - die anderen sollen uns folgen
		nachbar->addNachbar(entfernung, fischspeed,
					fischposx, fischposy, fischposz
				);
	}
}

/**
 * Dekonstruktor
 */
Fisch::~Fisch(void)
{
}