#ifndef FIBS_S
#define FIBS_S

#include <iostream>

template<class T>class Vektor;

template <class T>
class Matrix {
  public:
    Matrix(int n, int m); // Konstruktor fr n x m Elemente
    ~Matrix(); // Destruktor
    int num_rows() const; // Anzahl Zeilen
    int num_cols() const; // Anzahl Spalten
    Vektor<T>* operator[](int i) const;
  private:
    Vektor<T>** p; // Array von Zeigern auf Objekte Vektor
    int rows;
    int columns;
};

template<class T>
Matrix<T>::Matrix(int n, int m){
  this->p = new Vektor<T>*[n];
  for(int i=0; i<n; i++){
    this->p[i] = new Vektor<T>(m);
  }

  this->rows = n;
  this->columns = m;
};

// Destruktor
template<class T>
Matrix<T>::~Matrix(){
  delete [] p;
} ;

// Anzahl Zeilen
template<class T>
int Matrix<T>::num_rows() const{
  return this->rows;
};

template<class T>
int Matrix<T>::num_cols() const{
  return this->columns;
};

template <class T>
Vektor<T>* Matrix<T>::operator[](int i) const{
  //assert (i >= 0 && i < size );
  return p[i];
};

#endif