#ifndef FIBS_W
#define FIBS_W

#include <iostream>

template <class T>
class Vektor {
  public:
    explicit Vektor(int n); // Konstruktor fr n Elemente
    Vektor(const Vektor<T>& v); // copy Vector
    Vektor(const T a[], int n); // copy an array
    ~Vektor(); // Destruktor
    T& element(int i); // Zugriff auf i-tes Element
    int num_elem() const; // Anzahl Elemente
    T& operator[](int i);
    const T& operator[](int i) const;
    Vektor<T>& operator=(const Vektor<T>* v);
  private:
    T* p;
    int size;
};

template <class T>
Vektor<T>::Vektor(const T a[], int n)
{
  //assert(n > 0);
  size = n;
  p = new T[size];
  for (int i = 0; i < size; ++i)  {
    p[i] = a[i];
  }
};

template <class T>
Vektor<T>::Vektor(int n): size(n){
  //assert(n > 0);
  p = new T[size];
};

template <class T>
Vektor<T>::Vektor(const Vektor<T> &v){
  p = new T[v.size];
  for(int i = 0; i < size; i++){
    p[i] = v.element(i);
  }
}

template <class T>
Vektor<T>::~Vektor(void){
  delete [] p;
};

template <class T>
T& Vektor<T>::element(int i){
  return this->p[i];
};

template <class T>
int Vektor<T>::num_elem() const{
  return this->size;
};

template <class T>
T& Vektor<T>::operator[](int i){
  //assert (i >= 0 && i < size );
  return (p[i]);
};

template <class T>
const T& Vektor<T>::operator[](int i) const{
  //assert (i >= 0 && i < size );
  return (p[i]);
};

template <class T>
Vektor<T>& Vektor<T>::operator=(const Vektor<T>* v)
{
  //assert(v.size == size);
  for (int i = 0; i < size; ++i) {
    p[i] = v->p[i];
  }
  return *this;
};

#endif