package com.google.gwt.sample.mail.client;

import java.util.ArrayList;
import com.google.gwt.user.client.ui.*;

/**
 * container class for a contentpage
 */
public class Content {
	private String name;
	private ArrayList al;
	
	/**
	 * constructor accepting arraylist
	 * @param name
	 * @param al
	 */
	public Content(String name, ArrayList al) {
		this.name = name;
		this.al = al;
	}
	
	/**
	 * constructr accepting a sink
	 * @param name
	 * @param sink
	 */
	public Content(String name, Sink sink) {
		this(name, new ArrayList());
		this.al.add(sink);
	}
	
	/**
	 * returns the name
	 * @return name of content
	 */
	public String getName() {
		return name;
	}
	
	/**
	 * returns the size of the arraylist
	 * @return size of ArrayList
	 */
	public int size() {
		return al.size();
	}
	
	/**
	 * returns one item of the arraylist
	 * @param i
	 * 			index of the item
	 * @return widget 			
	 */
	public Widget get(int i) {
		return (Widget) al.get(i);
	}
}
