/*
 * Copyright 2007 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.sample.mail.client;

import com.google.gwt.user.client.ui.*;

/**
 * A simple example of an 'about' dialog box.
 */
public class ErrorDialog extends DialogBox {

	/**
	 * constructor
	 */
	public ErrorDialog() {
		setText("Error Dialog");
		VerticalPanel outer = new VerticalPanel();

		HTML text = new HTML("ERROR 404");
		text.setStyleName("mail-AboutText");
		outer.add(text);

		outer.add(new Button("Close", new ClickListener() {
			public void onClick(Widget sender) {
				hide();
			}
		}));

		setWidget(outer);
	}

	/**
	 * 
	 * @param key
	 * @param modifiers
	 */
	public boolean onKeyDownPreview(char key, int modifiers) {
		switch (key) {
		case KeyboardListener.KEY_ENTER:
		case KeyboardListener.KEY_ESCAPE:
			hide();
			break;
		}

		return true;
	}
}
