/*
 * Copyright 2007 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.sample.mail.client;

import java.util.ArrayList;

import com.google.gwt.user.client.ui.*;

/**
 * A composite for displaying the startpage
 */
public class Home extends Sink {
	private FlexTable table = new FlexTable();

	/**
	 * constructor
	 */
	public Home() {
		super("Home");
		show();
		
		initTable();

		initWidget(table);
		setStyleName("mail-List");
	}

	/**
	 * Initializes the table so that it contains enough rows for a full page of
	 * emails. Also creates the images that will be used as 'read' flags.
	 */
	private void initTable() {
		// Setup the table.
		table.setCellSpacing(0);
		table.setCellPadding(0);
		table.setWidth("100%");

		// Create the header row.
		table.setText(0, 0, "Welcome Back");
		table.getFlexCellFormatter().setColSpan(0, 0, 2);
		table.getRowFormatter().setStyleName(0, "mail-ListHeader");

		table.setText(1, 0, "Linke Seite");
		table.setText(1, 1, "Rechte Seite");
	}

	/**
	 * @see Sink#show()
	 */
	public void show() {
		ArrayList al = new ArrayList();
//		al.add(table);
		
		Mail.get().topPanel(new ArrayList());
		Mail.get().rightPanel(new Content(name, al));
		super.show();
	}
}
