/*
 * Copyright 2007 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.sample.mail.client;

import com.google.gwt.user.client.ui.*;

/**
 * A 'sink' is a single panel of the kitchen sink. They are meant to be lazily
 * instantiated so that the application doesn't pay for all of them on startup.
 */
public class Sink extends Composite {
	protected int shortcut = -1;

	protected String name;

	/**
	 * 
	 * @return name
	 */
	public String getName() {
		return name;
	}

	/**
	 * 
	 * @param name
	 */
	public Sink(String name) {
		this.name = name;
	}

	/**
	 * 
	 * 
	 */
	public void show() {
		// create a new item on the history stack. This will ultimately result
		// in onHistoryChanged() being called. It will call show() again,
		// but nothing will happen because it will request the exact
		// same sink we're already showing.
		Mail.get().addHistory(this);
	}

	/**
	 * 
	 * @param path
	 */
	public void show(String path) {
		Mail.get().addHistory(path, this);
	}

	/**
	 * 
	 * @return shortcut index
	 */
	public int getShortcut() {
		return shortcut;
	}

	/**
	 * 
	 * @param shortcut
	 */
	public void setShortcut(int shortcut) {
		this.shortcut = shortcut;
	}
}