/*
 * Copyright 2007 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.sample.mail.client;

import com.google.gwt.user.client.*;
import com.google.gwt.user.client.ui.*;

/**
 * The top panel, which contains the 'welcome' message and various links.
 */
public class TopPanel extends HorizontalPanel implements ClickListener {

	/**
	 * An image bundle for this widgets images.
	 */
	public interface Images extends ImageBundle {
		AbstractImagePrototype logo();
	}

	private HTML signOutLink = new HTML("<a href='javascript:;'>Sign Out</a>");
	private HTML aboutLink = new HTML("<a href='javascript:;'>About</a>");

	private HorizontalPanel menu;
	private HorizontalPanel links;

	private final HTML logo;

	/**
	 * 
	 * @param images
	 */
	public TopPanel(Images images) {
		setHorizontalAlignment(HorizontalPanel.ALIGN_RIGHT);

		// dynamic menu
		menu = new HorizontalPanel();

		// static menu
		links = new HorizontalPanel();
		links.setSpacing(4);
		links.add(menu);
		links.add(aboutLink);
		links.add(signOutLink);

		logo = new HTML("<a href='javascript:;'>" + images.logo().createImage() + "</a>");
		logo.addClickListener(this);
		add(logo);
		setCellHorizontalAlignment(logo, HorizontalPanel.ALIGN_LEFT);

		add(links);

		signOutLink.addClickListener(this);
		aboutLink.addClickListener(this);

		// initWidget(outer);
		setStyleName("mail-TopPanel");
		links.setStyleName("mail-TopPanelLinks");
	}

	/**
	 * 
	 * @param sender
	 */
	public void onClick(Widget sender) {
		if (sender == signOutLink) {
			Window.alert("If this were implemented, you would be signed out now.");
		} else if (sender == aboutLink) {
			// When the 'About' item is selected, show the AboutDialog.
			// Note that showing a dialog box does not block -- execution
			// continues
			// normally, and the dialog fires an event when it is closed.
			AboutDialog dlg = new AboutDialog();
			dlg.show();
			dlg.center();
		} else if (sender == logo) {
			Mail.get().rightPanel(new Content("Home", new Home()));
		}
	}

	/**
	 * 
	 * @param widget
	 */
	public void addMenuItem(Widget widget) {
		menu.add(widget);
	}

	/**
	 * clears the menu
	 */
	public void clearMenu() {
		menu.clear();
	}
}
