/*
 * Copyright 2007 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.sample.mail.client.rpc;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * A simple structure containing the basic components of an email.
 */
public final class MailItem implements IsSerializable {
	private String version;
	
	/**
	 * The mail id
	 */
	public Integer id;

	/**
	 * The sender's name.
	 */
	public String sender;

	/**
	 * The sender's email.
	 */
	public String email;

	/**
	 * The email subject line.
	 */
	public String subject;

	/**
	 * The email's HTML body.
	 */
	public String body;

	/**
	 * The email's incoming date
	 */
	public String date;

	/**
	 * Read flag.
	 */
	public boolean read;
	
	/**
	 * basic constructor is needed
	 *
	 */
	public MailItem() {
		
	}

	/**
	 * constructor for an email item
	 * @param id
	 * @param sender
	 * @param email
	 * @param subject
	 * @param body
	 */
	public MailItem(Integer id, String sender, String email, String subject, String body) {
		this.id = id;
		this.sender = sender;
		this.email = email;
		this.subject = subject;
		this.body = body;
		this.date = "Mi, 24. Okt 12:54";
	}
	
	/**
	 * Fetches the version of the note. Used for versioning notes as part of
	 * optimistic concurrency. See 
	 * {@link com.google.gwt.sample.mail.server.MailServiceImpl} for
	 * more details.
	 * 
	 * @return the version of the note
	 */
	public String getVersion() {
		return version;
	}

	/**
	 * Sets the version to the specified value.
	 * 
	 * @param version
	 *            the version to store
	 */
	public void setVersion(String version) {
		this.version = version;
	}
}
