/*
 * Copyright 2007 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.sample.mail.client.ui.calendar;

import java.util.ArrayList;

import com.google.gwt.sample.mail.client.Content;
import com.google.gwt.sample.mail.client.Mail;
import com.google.gwt.sample.mail.client.Shortcuts;
import com.google.gwt.sample.mail.client.Sink;
import com.google.gwt.user.client.*;
import com.google.gwt.user.client.ui.*;

/**
 * A tree displaying a some groups for the calendar.
 */
public class Calendar extends Sink {
	/**
	 * An image bundle for this widgets images.
	 */
	public interface Images extends ImageBundle {
		AbstractImagePrototype logo();
	}

	/**
	 * Constructs a new mailboxes widget with a bundle of images.
	 * 
	 * @param images
	 *            a bundle that provides the images for this widget
	 */
	public Calendar(Shortcuts.Images images) {
		super("Kalender");
		
		// Maintree for different groups
		Tree tree = new Tree(images);
		
		// Demo Group 1 'Contacts'
		TreeItem group1 = new TreeItem(imageItemHTML(images.home(), "Kontakte"));
		addImageItem(group1, "Geburts- und Jahrestage", images.drafts());
		tree.addItem(group1);
		group1.setState(true);

		// Demo Group 2 'Calendar'
		TreeItem group2 = new TreeItem(imageItemHTML(images.home(), "Kalender"));
		addImageItem(group2, "Persönlich", images.drafts());
		addImageItem(group2, "Feiertage", images.drafts());
		addImageItem(group2, "Studium", images.drafts());
		tree.addItem(group2);		
		group2.setState(true);

		// init
		initWidget(tree);
	}

	/**
	 * A helper method to simplify adding tree items that have attached images.
	 * {@link #addImageItem(TreeItem, String) code}
	 * 
	 * @param root
	 *            the tree item to which the new item will be added.
	 * @param title
	 *            the text associated with this item.
	 */
	private TreeItem addImageItem(TreeItem root, String title, AbstractImagePrototype imageProto) {
		TreeItem item = new TreeItem(imageItemHTML(imageProto, title));
		root.addItem(item);
		return item;
	}

	/**
	 * Generates HTML for a tree item with an attached icon.
	 * 
	 * @param imageUrl
	 *            the url of the icon image
	 * @param title
	 *            the title of the item
	 * @return the resultant HTML
	 */
	private String imageItemHTML(AbstractImagePrototype imageProto, String title) {
		return "<span>" + imageProto.getHTML() + title + "</span>";
	}

	/**
	 * @see Sink#show() 
	 */
	public void show() {
		ArrayList al = new ArrayList();
		al.add(new Button("Calendar", new ClickListener() {
			public void onClick(Widget sender) {
				Window.alert("How high?");
			}
		}));
		Mail.get().rightPanel(new Content(name, al));

		ArrayList top = new ArrayList();

		top.add(new Button("Neu", new ClickListener() {
			public void onClick(Widget sender) {
				Window.alert("How high?");
			}
		}));

		top.add(new Button("Drucken", new ClickListener() {
			public void onClick(Widget sender) {
				Window.alert("How high?");
			}
		}));

		top.add(new Button("Löschen", new ClickListener() {
			public void onClick(Widget sender) {
				Window.alert("How high?");
			}
		}));

		top.add(new Button("Vorherige", new ClickListener() {
			public void onClick(Widget sender) {
				Window.alert("How high?");
			}
		}));

		top.add(new Button("Heute", new ClickListener() {
			public void onClick(Widget sender) {
				Window.alert("How high?");
			}
		}));

		top.add(new Button("Weiter", new ClickListener() {
			public void onClick(Widget sender) {
				Window.alert("How high?");
			}
		}));

		top.add(new Button("Gehe zu", new ClickListener() {
			public void onClick(Widget sender) {
				Window.alert("How high?");
			}
		}));

		top.add(new Button("Tag", new ClickListener() {
			public void onClick(Widget sender) {
				Window.alert("How high?");
			}
		}));

		top.add(new Button("Arbeitswoche", new ClickListener() {
			public void onClick(Widget sender) {
				Window.alert("How high?");
			}
		}));

		top.add(new Button("Woche", new ClickListener() {
			public void onClick(Widget sender) {
				Window.alert("How high?");
			}
		}));

		top.add(new Button("Monat", new ClickListener() {
			public void onClick(Widget sender) {
				Window.alert("How high?");
			}
		}));

		top.add(new Button("Liste", new ClickListener() {
			public void onClick(Widget sender) {
				Window.alert("How high?");
			}
		}));

		Mail.get().topPanel(top);
		super.show();
	}
}
