/*
 * Copyright 2007 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.sample.mail.client.ui.mail;

import com.google.gwt.sample.mail.client.Mail;
import com.google.gwt.user.client.ui.*;

/**
 * A tree displaying a set of email folders.
 */
public class Mailbox extends TreeItem {

	/**
	 * Constructs a new mailboxes widget with a bundle of images.
	 * @param box
	 * @param path
	 * @param title
	 * @param imageProto
	 */
	public Mailbox(Mailboxes box, String path, String title, AbstractImagePrototype imageProto) {
		super(imageItemHTML(box, path, title, imageProto));
	}

	/**
	 * Generates HTML for a tree item with an attached icon.
	 * 
	 * @param box
	 * @param path
	 * @param title
	 * @param imageProto
	 * @return the resultant html
	 */
	private static HTML imageItemHTML(final Mailboxes box, final String path, String title, AbstractImagePrototype imageProto) {
		HTML item = new HTML("<span><a href='javascript:;'>"+ imageProto.getHTML() + title + "</a></span>");
		item.addClickListener(new ClickListener() {
			public void onClick(Widget sender) {
				Mail.get().addHistory(box.getName() + "/" + path, box);
			}
		});
		return item;
	}
}