/*
 * Copyright 2007 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.sample.mail.client.ui.mail.compose;

import java.util.ArrayList;

import com.google.gwt.sample.mail.client.Mail;
import com.google.gwt.sample.mail.client.Sink;
import com.google.gwt.user.client.*;
import com.google.gwt.user.client.ui.*;

/**
 * A composite that displays a list of emails that can be selected.
 */
public class MailCompose extends Sink {
	private FlexTable table = new FlexTable();
	private TextArea area = new TextArea();

	/**
	 * constructor
	 */
	public MailCompose() {
		super("Mail erstellen");
		show();

		// Setup the table.
		table.setCellSpacing(0);
		table.setCellPadding(0);
		table.setWidth("100%");

		initWidget(table);
		setStyleName("mail-List");

		initTable();
	}

	/**
	 * Initializes the table so that it contains enough rows for a full page of
	 * emails. Also creates the images that will be used as 'read' flags.
	 */
	private void initTable() {
		int i=0;

		// Create the header row.
		table.setText(0, 0, "E-Mail erstellen");
		table.getFlexCellFormatter().setColSpan(0, 0, 2);
		table.getRowFormatter().setStyleName(0, "mail-ListHeader");
		
		ListBox lb = new ListBox();
		lb.setVisibleItemCount(1);
	    lb.addItem("foo@example.com");
	    lb.addItem("foo2@example.com");

	    // Add it to the root panel.
	    RootPanel.get().add(lb);
		
		table.setText(i + 1, 0, "Von");
		table.setWidget(i + 1, 1, lb);
		i++;
		
		MultiWordSuggestOracle oracle = new MultiWordSuggestOracle();  
		oracle.add("Benoit Mandelbrot");
		oracle.add("Albert Einstein");
		oracle.add("Rene Descartes");
		oracle.add("Bob Saget");
		oracle.add("Ludwig von Beethoven");
		oracle.add("Richard Feynmann");
		oracle.add("Alan Turing");
		oracle.add("John von Neumann");
		
		table.setText(i + 1, 0, "An");
		table.setWidget(i + 1, 1, new SuggestBox(oracle));
		i++;
		
		table.setText(i + 1, 0, "Kopie an");
		table.setWidget(i + 1, 1, new SuggestBox(oracle));
		i++;
		
		table.setText(i + 1, 0, "Blindkopie an");
		table.setWidget(i + 1, 1, new SuggestBox(oracle));
		i++;
		
		table.setText(i + 1, 0, "Betreff");
		table.setWidget(i + 1, 1, new TextBox());
		i++;

		table.setText(i + 1, 0, "Eingabefeld");
		table.setWidget(i + 1, 1, createRichText());
	}

	/**
	 * 
	 * @param recipient
	 */
	public void setRecipient(String recipient) {
		((SuggestBox) table.getWidget(2, 1)).setText(recipient);
	}

	/**
	 * 
	 * @param cc
	 */
	public void setCC(String cc) {
		((SuggestBox) table.getWidget(3, 1)).setText(cc);
	}

	/**
	 * 
	 * @param bcc
	 */
	public void setBCC(String bcc) {
		((SuggestBox) table.getWidget(4, 1)).setText(bcc);
	}

	/**
	 * 
	 * @param subject
	 */
	public void setSubject(String subject) {
		((TextBox) table.getWidget(5, 1)).setText(subject);
	}

	/**
	 * 
	 * @param text
	 */
	public void setText(String text) {
		area.setText(text);
	}

	/**
	 * 
	 * @return
	 */
	private Widget createRichText() {
		area = new TextArea();

		VerticalPanel p = new VerticalPanel();
		p.add(area);
		//p.add(toolbar)

		area.setHeight("14em");
		area.setWidth("100%");
		p.setWidth("100%");
		return p;
	}

	/**
	 * @see Sink#show()
	 */
	public void show() {
		ArrayList top = new ArrayList();

		top.add(new Button("Abschicken", new ClickListener() {
			public void onClick(Widget sender) {
				Window.alert("How high?");
			}
		}));

		top.add(new Button("Entwurf speichern", new ClickListener() {
			public void onClick(Widget sender) {
				Window.alert("How high?");
			}
		}));

		top.add(new Button("Beilegen", new ClickListener() {
			public void onClick(Widget sender) {
				Window.alert("How high?");
			}
		}));

		top.add(new Button("Rückgängig", new ClickListener() {
			public void onClick(Widget sender) {
				Window.alert("How high?");
			}
		}));

		top.add(new Button("Wiederholen", new ClickListener() {
			public void onClick(Widget sender) {
				Window.alert("How high?");
			}
		}));

		top.add(new Button("Ausschneiden", new ClickListener() {
			public void onClick(Widget sender) {
				Window.alert("How high?");
			}
		}));

		top.add(new Button("Kopieren", new ClickListener() {
			public void onClick(Widget sender) {
				Window.alert("How high?");
			}
		}));

		top.add(new Button("Einfügen", new ClickListener() {
			public void onClick(Widget sender) {
				Window.alert("How high?");
			}
		}));

		top.add(new Button("Suchen", new ClickListener() {
			public void onClick(Widget sender) {
				Window.alert("How high?");
			}
		}));

		top.add(new Button("Ersetzen", new ClickListener() {
			public void onClick(Widget sender) {
				Window.alert("How high?");
			}
		}));

		Mail.get().topPanel(top);
		super.show();
	}
}
