/*
 * Copyright 2007 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.sample.mail.client.ui.notices;

import java.util.ArrayList;

import com.google.gwt.sample.mail.client.Content;
import com.google.gwt.sample.mail.client.Mail;
import com.google.gwt.sample.mail.client.Sink;
import com.google.gwt.user.client.*;
import com.google.gwt.user.client.ui.*;

/**
 * Composite that represents a collection of <code>Task</code> items.
 */
public class Notices extends Sink {

	/**
	 * constructor
	 */
	public Notices() {
		super("Notizen");
		SimplePanel panel = new SimplePanel();
		VerticalPanel list = new VerticalPanel();
		panel.setWidget(list);
		list.add(new CheckBox("Get groceries"));
		list.add(new CheckBox("Walk the dog"));
		list.add(new CheckBox("Start Web 2.0 company"));
		list.add(new CheckBox("Write cool app in GWT"));
		list.add(new CheckBox("Get funding"));
		list.add(new CheckBox("Take a vacation"));
		initWidget(panel);
		setStyleName("mail-Tasks");
	}

	/**
	 * @see Sink#show()
	 */
	public void show() {
		ArrayList al = new ArrayList();
		al.add(new Button("Notizen", new ClickListener() {
			public void onClick(Widget sender) {
				Window.alert("How high?");
			}
		}));
		Mail.get().rightPanel(new Content(name, al));

		ArrayList top = new ArrayList();

		top.add(new Button("Neu", new ClickListener() {
			public void onClick(Widget sender) {
				Window.alert("How high?");
			}
		}));

		top.add(new Button("Drucken", new ClickListener() {
			public void onClick(Widget sender) {
				Window.alert("How high?");
			}
		}));

		top.add(new Button("Löschen", new ClickListener() {
			public void onClick(Widget sender) {
				Window.alert("How high?");
			}
		}));

		Mail.get().topPanel(top);
		super.show();
	}
}
