<?php
/**
 * @author Martin Bories
 * @copyright 2009 Martin Bories, all rights reserved
 * @since Sa, 22 Aug 2009
 */
class McryptUtil {
	/**
	 * contains the mcrypt_module_open result
	 *
	 * @access public
	 * @var $mcrypt
	 */
	public static $mcrypt;

	/**
	 * opens a new mcrypt module
	 *
	 * @access public
	 * @method open()
	 * @param $algorithm	String	mcrypt parse algorithm
	 * @param $mode	String	mcrypt parse mode
	 */
	public static function open($algorithm = 'blowfish', $mode = 'cfb') {
		self::$mcrypt = mcrypt_module_open($algorithm, '', $mode, '');
	}

	/**
	 * encrypts an array
	 *
	 * @access public
	 * @method encrypt()
	 * @param $crypt	Array	contains the informations that should be encrypted
	 */
	public static function encrypt($crypt, $mcryptKey) {
		$iv = mcrypt_create_iv(mcrypt_enc_get_iv_size(self::$mcrypt), MCRYPT_RAND);
		mcrypt_generic_init(self::$mcrypt, $mcryptKey, $iv);
		$crypted = mcrypt_generic(self::$mcrypt, $crypt);
		mcrypt_generic_deinit(self::$mcrypt);
		
		return $iv.$crypted;
	}

	/**
	 * decrypts an array or a string
	 *
	 * @access public
	 * @method decrypt()
	 * @param $crypt	Array/String	contains the informations that should be decrypted
	 * @param $mcryptKey	String	contains the mcryptKey
	 */
	public static function decrypt($crypt, $mcryptKey) {
		$ivsize = mcrypt_enc_get_iv_size(self::$mcrypt);
		$iv = substr($crypt, 0, $ivsize);
		$crypt = substr($crypt, $ivsize);
		mcrypt_generic_init(self::$mcrypt, $mcryptKey, $iv);
		$crypt = mdecrypt_generic(self::$mcrypt, $crypt);

		return $crypt;
	}

}
?>