


import java.io.*;
import java.util.regex.*;
public class Adreli
{
	//main-Methode
	public static void main(String[] args)
	{
			start();
	}

	static String[] persotemp1 = new String[10000];
	// Array um die Datenstze
	// aufzunehemen und zu sichern
	// (max.10000 Datenstze)

	static String[] persotemp2 = new String[10000];
	// Array um die Datenstze
	// zu laden und zum auflisten
	// (max. 10000 Datenstze)

	static int persotemp1pos = 0;
	// Die Position des Arrays persotemp1
	// beim Aufnehmen wird definiert

	static int persotemp2posLaden = 0;
	// Die Position des Arrays persotemp2
	// beim Laden wird definiert

	static int persotemp2posAuflisten = 0;
	// Die Position des Arrays persotemp2
	// beim Auflisten wird definiert

	static int anzahlBesetzterFelder2 = 0;
	// Besetzte Felder im Array
	// persotemp2 nach dem Laden

	static int datensatznr = 1;
	// Aktuelle Nummer des Datensatzes
	// beim Auflisten



	/****
	*** START
	**
	*/

	// Anfangsfenster des Programms

	public static void start()
	{
		System.out.println("");
		System.out.println("   *******************************************");
		System.out.println("   *                                         *");
		System.out.println("   *      ADRELI - Adressverwaltung          *");
		System.out.println("   *                                         *");
		System.out.println("   * Wollen Sie...                           *");
		System.out.println("   *                                         *");
		System.out.println("   *       ...eine neue Person aufnehmen: >1 *");
		System.out.println("   *            ...Datensaetze auflisten: >2 *");
		System.out.println("   *...Datensaetze in eine Datei sichern: >3 *");
		System.out.println("   *...Datensaetze aus einer Datei laden: >4 *");
		System.out.println("   *                   ...Datei loeschen: >5 *");
		System.out.println("   *           ...das Programm verlassen: >6 *");
		System.out.println("   *                                         *");
		System.out.println("   *******************************************");
		System.out.println("");


		//Auswahl der Funktionen
		int auswahl = StdInput.readInt("Bitte auswaehlen:");
		switch (auswahl) {
		case 1:
			aufnahme1();
			break;
		case 2:
			auflisten1();
			break;
		case 3:
			dateispeichern1();
			break;
		case 4:
			dateiladen1();
			break;
		case 5:
			dateiloeschen();
			start();
		case 6:
			System.out.println("");
			System.out.println("Vieln Dank fr die Benutzung!");
			System.out.println("");
			System.exit(0);
			break;
		default:
			System.out.println("Falsche Eingabe.");
			start();
		}
	}

	/****
	*** Eine neue Person hinzufgen: >1
	**
	*/

	//Eingabe der Personendaten in den Ram
	public static void aufnahme1() {
		System.out.println("");
		System.out.println("++++++++++++++++++++++++++++++++++++++++++++");
		System.out.println("                                        ");
		System.out.println("   Geben Sie bitte die Daten ein:       ");
		System.out.println("                                 	 	");

		try {
			System.out.print("   Name: ");
				try {
					BufferedReader name = new BufferedReader(new InputStreamReader(System.in));
					Pattern pattern = null;
					pattern = Pattern.compile("([a-z]|[A-Z])+");
					String na = name.readLine();
					Matcher matcher = pattern.matcher(na);
					if (matcher.matches()){
						persotemp1[persotemp1pos] = na;
					}
					else {
						System.err.print("Fehler bei der Eingabe - nur Buchstaben");
						aufnahme1();
					}

				}
				catch (PatternSyntaxException e){
				System.out.println(e.getMessage());
				}
			System.out.print("   Vorname: ");
			try {
				BufferedReader vorname = new BufferedReader(new InputStreamReader(System.in));
				Pattern pattern = null;
				pattern = Pattern.compile("([a-z]|[A-Z])+");
				String na = vorname.readLine();
				Matcher matcher = pattern.matcher(na);
				if (matcher.matches()) {
					persotemp1[persotemp1pos + 1] = na;
				}
				else {
					System.err.print("Fehler bei der Eingabe - nur Buchstaben");
					aufnahme1();
				}
			}
			catch (PatternSyntaxException e) {
			System.out.println(e.getMessage());
			}

			System.out.print("   Anrede: ");
			try {
				BufferedReader anrede = new BufferedReader(new InputStreamReader(System.in));
				Pattern pattern = null;
				pattern = Pattern.compile("([a-z]|[A-Z])+");
				String na = anrede.readLine();
				Matcher matcher = pattern.matcher(na);
				if (matcher.matches()){
					persotemp1[persotemp1pos + 2] = na;
				}
				else {
					System.err.print("Fehler bei der Eingabe - nur Buchstaben");
					aufnahme1();
				}
			}
			catch (PatternSyntaxException e){
			System.out.println(e.getMessage());
			}

			System.out.print("   Strasse: ");
			try {
				BufferedReader strasse = new BufferedReader(new InputStreamReader(System.in));
				Pattern pattern = null;
				pattern = Pattern.compile("([a-z]|[A-Z])+([ ]([0-9])+)?");
				String na = strasse.readLine();
				Matcher matcher = pattern.matcher(na);
				if (matcher.matches()) {
					persotemp1[persotemp1pos + 3] = na;
				}
				else {
					System.err.println("Eingabe wiederholen - Buchstaben/Zahlen");
					aufnahme1();
				}
			}
			catch (PatternSyntaxException e){
			System.out.println(e.getMessage());
			}

			System.out.print("   PLZ: ");
			try {
				BufferedReader plz = new BufferedReader(new InputStreamReader(System.in));
				Pattern pattern = null;
				pattern = Pattern.compile("([0-9])+");
				String na = plz.readLine();
				Matcher matcher = pattern.matcher(na);
				if (matcher.matches()) {
					persotemp1[persotemp1pos + 4] = na;
				}
				else {
					System.err.print("Fehler bei der Eingabe - nur Zahlen");
					aufnahme1();
				}
			}
			catch (PatternSyntaxException e){
			System.out.println(e.getMessage());
			}

			System.out.print("   Ort: ");
			try {
				BufferedReader ort = new BufferedReader(new InputStreamReader(System.in));
				Pattern pattern = null;
				pattern = Pattern.compile("([a-z]|[A-Z])+");
				String na = ort.readLine();
				Matcher matcher = pattern.matcher(na);
				if (matcher.matches()){
					persotemp1[persotemp1pos + 5] = na;
				}
				else {
					System.err.print("Fehler bei der Eingabe - nur Buchstaben");
					aufnahme1();
				}
			}
			catch (PatternSyntaxException e) {
			System.out.println(e.getMessage());
			}

			System.out.print("   Telefon: ");
			try {
				BufferedReader telefon = new BufferedReader(new InputStreamReader(System.in));
				Pattern pattern = null;
				pattern = Pattern.compile("([0-9]([ ]?)(/?))+");
				String na = telefon.readLine();
				Matcher matcher = pattern.matcher(na);
				if (matcher.matches()) {
					persotemp1[persotemp1pos + 6] = na;
				}
				else {
					System.err.print("Fehler bei der Eingabe - nur Zahlen");
					aufnahme1();
				}
			}
			catch (PatternSyntaxException e){
			System.out.println(e.getMessage());
			}

			System.out.print("   Fax: ");
			try {
				BufferedReader fax = new BufferedReader(new InputStreamReader(System.in));
				Pattern pattern = null;
				pattern = Pattern.compile("([0-9]([ ]?)(/?))+");
				String na = fax.readLine();
				Matcher matcher = pattern.matcher(na);
				if (matcher.matches()) {
					persotemp1[persotemp1pos + 7] = na;
				}
				else {
					System.err.print("Fehler bei der Eingabe - nur Zahlen");
					aufnahme1();
				}
			}
			catch (PatternSyntaxException e) {
			System.out.println(e.getMessage());
			}

			System.out.print("   Bemerkung: ");
			BufferedReader bemerkung = new BufferedReader(new InputStreamReader(System.in));
			persotemp1[persotemp1pos + 8] = bemerkung.readLine();
		}
		catch (IOException e) {
			System.err.println("Ein Fehler ist aufgetreten");
		}
		System.out.println("+++++++++++++++++++++++++++++++++++++++++++++++++++++");
		System.out.println("");
		int auswahlRichtig = StdInput.readInt("Stimmt's?   Ja >1    Nein >2");

		// berprfung, ob die einzelnen eingegebenen Daten richtig sind
		// und Abfrage, ob man noch weitere Personen anlegen will
		switch (auswahlRichtig) {
		case 1:
			persotemp1pos = persotemp1pos + 9;
			int neueAuswahl = StdInput.readInt("Noch eine Person aufnehmen?   Ja >1    Nein >2");

			switch (neueAuswahl) {
			case 1:

				aufnahme1();
				break;
			default:

				start();
				break;
			}
			break;
			case 2:
			aufnahme1();
			break;
			default:
			System.err.println("Falsche Eingabe!");
			start();
			break;
		}
	}
	/****
	*** Datensaetze auflisten: >2
	**
	*/


	// Datenstze aus dem RAM werden aufgelistet
	public static void auflisten1()
	{
		if (anzahlBesetzterFelder2 != 0) {

			System.out.println("***********************************************************");
			System.out.println("");
			System.out.println("Datensatz Nr. 	" +datensatznr + " von "+ anzahlBesetzterFelder2 / 9);
			System.out.println("");
			System.out.println("Name: " +persotemp2[persotemp2posAuflisten]);
			System.out.println("Vorname: " +persotemp2[persotemp2posAuflisten + 1]);
			System.out.println("Anrede: " +persotemp2[persotemp2posAuflisten + 2]);
			System.out.println("Strasse: " +persotemp2[persotemp2posAuflisten + 3]);
			System.out.println("PLZ: " + persotemp2[persotemp2posAuflisten + 4]);
			System.out.println("Ort: " + persotemp2[persotemp2posAuflisten + 5]);
			System.out.println("Telefon: " + persotemp2[persotemp2posAuflisten + 6]);
			System.out.println("Fax: " + persotemp2[persotemp2posAuflisten + 7]);
			System.out.println("Bemerkung: " + persotemp2[persotemp2posAuflisten + 8]);
			System.out.println("************************************************************");

			datensatznr++;
			persotemp2posAuflisten = persotemp2posAuflisten + 9;

			//Abfrage, ob man weitere Personendaten auflisten will
			if (persotemp2[persotemp2posAuflisten] != null)	{
				System.out.println("Wollen Sie einen weiteren Datensatz auflisten?");
				int auswahlauflisten = StdInput.readInt("		Ja >1		Nein >2");

				switch (auswahlauflisten) {
				case 1:
					auflisten1();
				case 2:
					start();
				}
			}
			else {
				persotemp2posAuflisten = 0;
				datensatznr = 1;

				System.out.println("Alle Datensaetze sind angezeigt, was wollen Sie jetzt tun?");
				int auflistenende = StdInput.readInt("Hauptmenue >1		Erneut auflisten >2");

				switch (auflistenende) {
				case 1:
					start();
				case 2:
					auflisten1();
				}
			}
		}
		else {
			System.out.println("--> Bitte zuerst Datensaetze aus Datei laden. <--");
			start();
		}
	}

	/****
	*** Datensaetze aus einer Datei laden: >3
	**
	*/

	// Datenstze aus der Datei in dem RAM werden geladen
	public static void dateiladen1()
	{
		persotemp2posLaden = 0;
		anzahlBesetzterFelder2 = 0;

		try {
			RandomAccessFile perso = new RandomAccessFile("Personen.txt", "r");
			perso.seek(0);
			for (String linex; (linex = perso.readLine()) != null;) {
				persotemp2[persotemp2posLaden] = linex;
				persotemp2posLaden++;
				anzahlBesetzterFelder2++;
			}
			datensatznr = 1;
			System.out.println("");
			System.out.println("--> Datensaetze erfolgreich aus Datei geladen <--");
			System.out.println("");
			perso.close();
		}
		catch (FileNotFoundException fnfex)	{
			System.out.println(fnfex.getMessage());
		}
		catch (IOException ioex) {
			System.out.println(ioex.getMessage());
		}
		start();
	}
	/****
	*** Datensaetze in eine Datei sichern: >4
	**
	*/


	// Datenstze aus der Datei in dem RAM werden geladen
	public static void dateispeichern1() {
		try {
			RandomAccessFile perso = new RandomAccessFile("Personen.txt", "rw");
			perso.seek(perso.length());

			for (int a = 0; persotemp1[a] != null; a++)	{
				perso.writeBytes(persotemp1[a]);
				perso.writeBytes("\n");
			}
			perso.close();
		}
		catch (FileNotFoundException fnfex)	{
			System.out.println(fnfex.getMessage());
		}
		catch (IOException ioex) {
			System.out.println(ioex.getMessage());
		}
		datensatznr = 0;
		persotemp2posLaden = 0;
		anzahlBesetzterFelder2 = 0;

		System.out.println("--> Datensaetze wurden gespeichert <--");
		start();
	}

	/****
	*** Datei lschen: >5
	**
	*/

	// Die angelegten Datenstze mit den Personendaten werden gelscht

	public static void dateiloeschen() {
		File file = new File("Personen.txt");
		if (file.exists()) {
			file.delete();
			System.out.println("Datei "+file+" wurde gelscht");
		}
		else {
			System.err.println("Datei "+file+" konnte nicht gelscht werden");
		}
	}

	}

