package Koch;
import java.awt.*;
import java.awt.event.*;

/**
 * GUI von Kochvis
 * @author tbr
 *
 */
@SuppressWarnings("serial")
public class KochGUI extends Frame {
	@SuppressWarnings("static-access")
	public KochGUI(KochApplication application) {
		super("KochGUI");
		GridBagLayout layout = new GridBagLayout();
		setLayout(layout);
		GridBagConstraints constraint = new GridBagConstraints();
		constraint.gridwidth = 1;
		constraint.gridheight = 7;
		constraint.gridx = 1;
		constraint.gridy = 1;
		
		final Canvas content = new KochCanvas();
		content.setSize(400,570);
//		constraint.fill = constraint.VERTICAL;
		constraint.fill = constraint.HORIZONTAL;
		layout.setConstraints(content, constraint);
		add(content);
				
		constraint.gridheight = 1;
		constraint.gridx = 2;
		constraint.gridy = 1;
		
		Label text1 = new Label("Depth of Recursion");
		layout.setConstraints(text1, constraint);
		add(text1);
		
		Choice choice1 = new Choice(); //Depth of Recursion
		choice1.addItemListener(application);
		for(int i=1; i<10; i++)
			choice1.add("depth "+i);
		constraint.gridy++;
		layout.setConstraints(choice1, constraint);
		add(choice1);
		
		Label text2 = new Label("Polygon");
		constraint.gridy++;
		layout.setConstraints(text2, constraint);
		add(text2);
		
		Choice choice2 = new Choice(); //Polygon
		choice2.addItemListener(application);
		for(int i=3; i<10; i++)
			choice2.add(i+"-sided");
		constraint.gridy++;
		layout.setConstraints(choice2, constraint);
		add(choice2);
		
		//Orientierung
		Label text3 = new Label("Orientation");
		constraint.gridy++;
		layout.setConstraints(text3, constraint);
		add(text3);
		
		final Choice choice3 = new Choice();
		choice3.addItemListener(application);
		choice3.add("clockwise");
		choice3.add("counterclockwise");
		constraint.gridy++;
		layout.setConstraints(choice3, constraint);
		add(choice3);
		
		Button button = new Button("draw");
		constraint.gridy++;
		constraint.ipady = 200;
		//constraint.fill = constraint.BOTH;
		layout.setConstraints(button, constraint);
		button.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
					content.repaint();
					choice3.add("asd");
					//choice3.repaint();
			}
		});
		add(button);
		
		
		setSize(600,600);
		setLocation(150,100);
//		setResizable(false);
		pack();
		addWindowListener(application);
		setVisible(true);
	}
}