package Koch;
import java.awt.*;

/**
 * Klasse zur Berechnung des Kochpolygons
 * @author tbr
 *
 */
public class Kochkurve {
	/**
	 * Zeichnet das Polygon
	 * Konstruktor
	 * @param g 
	 * @param width
	 * @param level
	 * @param polygons
	 * @param clockwise
	 */
	public Kochkurve(Graphics g, int width, int height, int level, int polygons, boolean clockwise) {
		int r = width/2, paddingx=r, paddingy=height/2;
		int multiplikant = clockwise ? 1 : -1;
		Node tmp=null;
		
		for(int i=0; i<polygons+1; i++) {
			double phi = i*2*Math.PI/polygons;
			double x = Math.sin(phi) * -r * 0.85;  //Fuelle nur 85% der Flaeche
			double y = Math.cos(phi) * -r * 0.85;
			
			Node calc = new Node(Math.round(x+paddingx), Math.round(y+paddingy));
			
			if(tmp != null)
				KochRek(g, tmp, calc, level, multiplikant);
	
			tmp = calc;
		}
	}
	
	/**
	 * rekursive Funktion um aus einer Linie eine Kochkurve zu machen
	 * @param g -> Grafikobjekt auf dem gezeichnet werden soll
	 * @param p -> Knotenpunkt der Linie
	 * @param q -> Knotenpunkt der Linie
	 * @param level -> Rekursionstiefe
	 * @param multiplikant -> um die Richtung der Operation zu beeinflussen
	 */
	public void KochRek(Graphics g, Node p, Node q, int level, int multiplikant) {
		if(level == 1) {
			g.drawLine((int)Math.round(p.x),(int)Math.round(p.y), 
					(int)Math.round(q.x), (int)Math.round(q.y));
			return;
		}
		
		Node R = new Node(p.x*2/3 + q.x/3, p.y*2/3 + q.y/3);
		Node T = new Node(p.x/3 + q.x*2/3, p.y/3 + q.y*2/3);	
		Node S = new Node((int)((R.x+T.x)/2+  multiplikant*((R.y-T.y)*Math.sqrt(3)/2)), 
				(int)((R.y+T.y)/2+   multiplikant*((T.x-R.x)*Math.sqrt (3)/2)));
		
		--level;
		KochRek(g, p, R, level, multiplikant);
		KochRek(g, R, S, level, multiplikant);
		KochRek(g, S, T, level, multiplikant);
		KochRek(g, T, q, level, multiplikant);
	}
}

/**
 * Abbildung eines Punktes im 2 Dimensionalen Koordinatensystem
 * @author Torben Brodt
 * 
 */
class Node {
	public double x, y;
	
	public Node(double x, double y) {
		this.x = x;
		this.y = y;
	}
}