<?php
    /******************************************/
    /*    Copyright  by Ludwig Kriechbaum    */
    /*             lu@venum-lk.de             */
    /*           http://venum-lk.de           */
    /******************************************/
    /*                CAPTCHA                 */
    /*      dynamische Sicherungsgrafik       */
    /******************************************/
    /* captcha.php                            */
    /*                                        */
    /* Beinhaltet die Erstellung einer        */
	/* Sicherungsgrafik (Anti-Spam)           */
    /*                                        */
    /*                             2010-01-00 */
    /******************************************/


	// Schriftart (System-ID)
	$font = 4;
	
	// Session starten
	session_start();
	
	// Captcha Code aus Session lschen
	unset($_SESSION['CAPTCHA']);

	// Wenn keine Gre angegeben wird
	if(!isset($_GET['size'])) $_GET['size'] = "l";

	// Das Hintergrundbild laden
	$im = imagecreatefrompng("bg_".$_GET['size'].".png");

	// Wenn es beim Auslesen einen Fehler gibt, wird hier gestoppt
	if(!$im) die("Fehler bei Bildauslesen");
	
	// Wenn Namensliste nicht vorhande, wird hier gestoppt
	if(!@file_exists("names.php")) die("Namensliste nicht vorhanden");
	
	// Namen laden
	include "names.php";
	
	// Zufallszahl aus einem bestimmten Bereich erzeugen
	function randnum($start, $end) {

		// Spektrum festlegen
		$numbers = range($start, $end);

		//
		srand((float)microtime() * 1000000);

		// Dass Array mischen
		shuffle($numbers);

		// Erstes Element des zufllig gemischten Arrays ausgeben
		return $numbers[0];

	}

	// Farben definieren
	$white = imagecolorallocate($im, 255, 255, 255);
	$black = imagecolorallocate($im, 0, 0, 0);

	// Die Abmessungen des Hintergrundbildes erfassen
	$width  = imagesx($im);
	$height = imagesy($im);
	
	// verfgbare Breite fr die drei Personen errechnen
	$spacex  = $width / 3;
	$spacey  = 150;

	// Bilder in den Verzeichnissen zhlen (-2 wegen Navigationszeichen . & ..)
	$men     = count(scandir("men/")) -2;
	$women   = count(scandir("women/")) -2;
	
	// Namen zhlen
	$names_m = count($names[0]) -1;
	$names_w = count($names[1]) -1;

	// Mann (0) oder Frau (1)
	$sex = randnum(0,1);
	
	// Position (1,2,3) auswhlen
	$position = randnum(1,3);
	
	// Wenn Frau
	if($sex) {
		
		$dir1 = "women/"; // Verzeichnis der "richtigen" Person
		$dir2 = "men/"; // Verzeichnis der "falschen" Personen
		$num1 = $women; // Anzahl der Bilder des "richtigen" Geschlechts
		$num2 = $men; // Anzahl der Bilder des "falschen" Geschlechts
		$num3 = $names_w;  // Anzahl der Namen des "richtigen" Geschlechts
		$question = "Wie heit die Frau auf diesem Bild?"; // Bildfrage
	
	// Wenn Mann	
	}else{
		
		$dir1 = "men/";
		$dir2 = "women/";
		$num1 = $men;
		$num2 = $women;
		$num3 = $names_m;
		$question = "Wie heit der Mann auf diesem Bild?";
		
	}
	
	// Bilder in PHP einlesen
	$pic[1]['s'] = imagecreatefrompng($dir1.randnum(1,$num1).".png");
	$pic[2]['s'] = imagecreatefrompng($dir2.randnum(1,$num2).".png");
	$pic[3]['s'] = imagecreatefrompng($dir2.randnum(1,$num2).".png");

	// Name 1
	$name[1] = $names[$sex][randnum(0,$num3)];
	
	// falsche Namen ermitteln
	// Name 2
	$temp = randnum(0,1);
	$count = $names_m;
	if($temp) $count = $names_w;
	$name[2] = $names[$temp][randnum(0,$count)];
	// Name 3
	$temp = randnum(0,1);
	$count = $names_m;
	if($temp) $count = $names_w;
	$name[3] = $names[$temp][randnum(0,$count)];
	
	// Bildabmessungen (BxH) ermitteln
	$pic[1]['w'] = imagesx($pic[1]['s']);
	$pic[1]['h'] = imagesy($pic[1]['s']);
	$pic[2]['w'] = imagesx($pic[2]['s']);
	$pic[2]['h'] = imagesy($pic[2]['s']);	
	$pic[3]['w'] = imagesx($pic[3]['s']);
	$pic[3]['h'] = imagesy($pic[3]['s']);
	
	// Laufparamteter fr falsche Personen
	$j = 2;
	
	// Die Positionen durchlaufen
	for($i=1;$i<4;$i++) {
		
		// Wenn aktuelle Position nicht die ermitellte Position
		if($i != $position) {
		
			// x und y Koordinaten der Figur ermitteln
		 	$pic[$j]['x']   = randnum(($i-1)*$spacex+1,$i*$spacex-$pic[$j]['w']-1);
	        $pic[$j]['y']   = randnum(1,$spacey-$pic[$j]['h']-1);
		
			// Figur in das Bild einfgen
		 	ImageCopy($im, $pic[$j]['s'], $pic[$j]['x'], $pic[$j]['y'], 0, 0, $pic[$j]['w'], $pic[$j]['h']);
		 	
		 	// Namen auf Position speichern
		 	$n[$i]['na'] = $name[$j];
		 	
		 	// Lnge (pixel) des Names ermitteln
			$n[$i]['le'] = imagefontwidth($font)*strlen($n[$i]['na']);
			
			// Prfen ob Namensrechteck auserhalb des Bildes liegt
			$x2 = $pic[$j]['x']+$pic[$j]['w']-$n[$i]['le'];
			if($x2 < $pic[$j]['x']) $x2 = $pic[$j]['x'];
		 	
		 	// Koordinaten des Namensrechteck ermitteln
			$n[$i]['x1'] = randnum($pic[$j]['x'], $x2);
			$n[$i]['y1'] = randnum($pic[$j]['y'], $pic[$j]['y']+$pic[$j]['h']-20);
			
			// Zhler hochsetzen
			$j++;
		
		// Wenn aktuelle Position die ermitellte Position	
		}else{
			
			// x und y Koordinaten der Figur ermitteln
			$pic[1]['x']   = randnum(($i-1)*$spacex+1,$i*$spacex-$pic[1]['w']-1);
	        $pic[1]['y']   = randnum(1,$spacey-$pic[1]['h']-1);
	        
	        // Figur in das Bild einfgen
			ImageCopy($im, $pic[1]['s'], $pic[1]['x'], $pic[1]['y'], 0, 0, $pic[1]['w'], $pic[1]['h']);
			
		 	// Namen auf Position speichern
		 	$n[$i]['na'] = $name[1];
		 	
			// Lnge (pixel) des Names ermitteln
			$n[$i]['le'] = imagefontwidth($font)*strlen($n[$i]['na']);
			
			// Koordinaten des Namensrechteck ermitteln
			$n[$i]['x1'] = randnum($pic[1]['x'], $pic[1]['x']+$pic[1]['w']-$n[$i]['le']);
			$n[$i]['y1'] = randnum($pic[1]['y'], $pic[1]['y']+$pic[1]['h']-20);
			
		}
		
	}
	
	// Namen in das Bild einfgen
	for($i=1;$i<4;$i++) {
		
		// Wenn x1 kleiner als 1 ist
		if($n[$i]['x1'] < 1) $n[$i]['x1'] = 1;
		
		// x2 & y2 errechnen
		$n[$i]['x2'] = $n[$i]['x1'] + $n[$i]['le'] + 8;
		$n[$i]['y2'] = $n[$i]['y1'] + 20;
		
		// Wenn x2 & y2 auerhalb des Bildes
		if($n[$i]['x2'] > $width-1) {
			$n[$i]['x1'] = $width-$n[$i]['le']-9;
			$n[$i]['x2'] = $width-1;
		}
		if($n[$i]['y2'] > 148) {
			$n[$i]['y1'] = 128;
			$n[$i]['y2'] = 148;
		}
		
		// Rechteck zeichnen
		imagefilledrectangle($im, $n[$i]['x1'], $n[$i]['y1'], $n[$i]['x2'], $n[$i]['y2'], $white);
		
		// Namen schreiben
		imagestring($im, $font, $n[$i]['x1']+4, $n[$i]['y1']+2, $n[$i]['na'], $black);
		
	}

	// Die linke Position der Frage errechnen
	$leftquestpos = ( $width - imagefontwidth($font)*strlen($question) )/2;

	// Die Frage schreiben
	imagestring($im, $font, $leftquestpos, $height-18, $question, $white);

	// Session String mit Namen fllen
	$_SESSION['CAPTCHA'] = $name[1];
	
	

	// BILD AUSGEBEN

	// Dem Browser die Bildart (png) mitteilen
	Header('Content-type: image/png');

	// Das png-Bild ausgeben
	imagepng($im);

	// Speicher freigeben
	imagedestroy($im);

?>