/**
 * starts a new post ajax request [..] by http://www.easy-coding.de
 * depending on the callback type this function will fill a target container 
 * 	by addressing it from its string ID, from reference or by usage of
 *	a custom callback function
 *
 * @param url		string			url to post the request
 * @param postData	string			data in GET format
 * @param callback 	string|object|function	how to address the target container
 * @return		boolean			everytime false
 */
function ajaxPost(url, postData, callback) {
	var req;
 	try {
		req = window.XMLHttpRequest ? new XMLHttpRequest(): new ActiveXObject("Microsoft.XMLHTTP"); 
	} catch (e) {
		// browser does not have ajax support
	}
	req.onreadystatechange = typeof callback == 'function' ? callback : function() {
		if (req.readyState == 4 && req.status == 200) {
			if(typeof callback == 'string') callback = document.getElementById(callback);
			if(callback) callback.innerHTML = req.responseText;
		}
	};
	req.open('POST', url, true);
	req.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
	req.send(postData);

	return false;
}
