<?php

########################################################
#                                                      #
#  class calculation v3                                #
#  2010 by cix88 - mario frost                         #
#                                                      #
#  contact: www.cix-blog.de                            #
#                                                      #
########################################################


class Calculation extends FPDF {

  var  $global;
  var  $customer;
  var  $calculation;
  var  $project;

  var  $colum;

  function CalculationInitRender() {

    $this->Open();
    $this->lMargin = 20;
    $this->bMargin = 40;
    $this->tMargin = 50;
    $this->SetAutoPageBreak(true);
    $this->SetDisplayMode(50);
    $this->SetLeftMargin(20);
    $this->SetFont('Helvetica','',9);

    // Zusammenrechnung
    $this->calculation['total_netto'] = 0;
    $this->calculation['total_tax'] = 0;
    $this->calculation['total_sum'] = 0;

    $this->AddPage();
    $this->ShowFirstPageHeader();

    // Beschreibung der Rechnung
    $this->ShowCalculationSubject();

    if ( $this->global['layout']['show_first_page'] == 1 ) {
      $this->AddPage();
      $this->SetY( $this->tMargin );
      
      // Beschreibung der Rechnung
      $this->ShowCalculationSubject();
    }

  }


  function Header() {

    if ( $this->global['layout']['show_sender'] == 1 ) {
      $this->ShowSenderInfo();
    }
    
  }


  function ShowSenderInfo() {

    // Background-Image
    if ( file_exists($this->global['layout']['background_image']) ) {
      $size = getimagesize($this->global['layout']['background_image']); 
      $bb = $size[0] / $this->global['layout']['background_image_dpi'] * 25.4; 
      $hh = $size[1] / $this->global['layout']['background_image_dpi'] * 25.4;
      $this->Image( $this->global['layout']['background_image'], 0, 0, $bb );
    }

    // Boxtext rechts
    $this->SetFont('Times','',7);
    $this->fc('typ2');
    $this->SetXY(160,100);
    $this->Cell(0, 3, trim($this->global['sender']['side_head']), 0, 1);
    
    $this->fc('typ3');
    $this->SetXY(160, $this->GetY() + 5 );
    $this->MultiCell(0, 4, trim($this->global['sender']['side_text']), 0, 'L');

  }


  function ShowFirstPageHeader() {

    if ( $this->global['layout']['show_sender'] == 1 ) {
      // Absenderzeile ber Kunden-Adresse
      $this->SetFont('Helvetica','U',8);
      $this->fc('typ2');
      $this->SetY(50);
      $this->Cell(0, 3, $this->global['sender']['adress_head'], 0, 1);
    }

    // Kunden-Adresse
    $this->SetFont('Helvetica','',12);
    $this->fc('typ1');
    $this->SetY(60);
    $this->MultiCell(0, 5, trim($this->customer['adress']), 0, 'L');

    // Wort Rechnung
    $this->SetFont('Helvetica','B',16);
    $this->fc('typ1');
    $this->SetXY(60,95);
    $this->Cell(0, 3, $this->global['lang']['calculation'], 0, 1);

    // Rechnung, Datum, Nummer
    $this->SetFont('Helvetica','',10);
    $this->SetXY( 110, 100 );
    $this->Cell(20, 4, $this->global['lang']['calculation_date'], 0, 0, 'L');
    $this->Cell(25, 4, $this->calculation['date'], 0, 1, 'R');
    $this->SetXY( 110, $this->GetY() );
    $this->Cell(20, 4, $this->global['lang']['calculation_number'], 0, 0, 'L');
    $this->Cell(25, 4, $this->calculation['number'], 0, 1, 'R');
	
  }


  function ShowCalculationSubject() {

    if ( $this->calculation['subject'] ) {
      $this->SetFont('Helvetica','B',10);
      $this->fc('typ1');
      $this->SetXY(33, $this->GetY() );
      $this->Cell(0, 5, $this->calculation['subject'], 0, 1);
    }
    if ( $this->calculation['subject_info'] ) {
      $this->SetFont('Helvetica','',9);
      $this->fc('typ1');
      $this->SetXY(33, $this->GetY() );
      $this->Cell(0, 5, $this->calculation['subject_info'], 0, 1);
    }
  
  }


  function CalculationEnd() {

    $this->Ln(5);
    $this->TestEndPage();

    // Spalten und Zeilen der Daten
    $this->ProjectRender();
    
    $this->Ln(5);
    $this->TestEndPage();

    $this->SetFont('Helvetica','',10);
    $this->fc('typ1');
    $this->SetX(33);
    $this->MultiCell(0, 5, $this->global['lang']['text_thanks'], 0, 'L');

    $this->SetFont('Helvetica','',10);
    $this->fc('typ1');
    $this->SetX(33);
    $this->MultiCell(0, 5, $this->global['lang']['text_payment'], 0, 'L');

    $this->SetFont('Helvetica','',8);
    $this->fc('typ1');
    $this->SetX(33);
    $this->MultiCell(0, 5, $this->global['lang']['text_agb'], 0, 'L');

  }


  function ProjectRender() {

    $step_x = $old_x = $this->GetX();
    $step_y = $old_y = $this->GetY();

    if ( $this->global['layout']['show_pos_num'] == 1 ) {
      $pos_w = 13;
      $this->MultiCell($pos_w, 3, 'Pos.', 0, 'C');
      $step_x += $pos_w;
    } else {
      $pos_w = 0;
    }

    $this->SetXY( $step_x, $old_y );

    // Spalten-Header
    for ( $i = 0; $i < count($this->project['header']); $i++ ) {
    
      $text = trim($this->project['header'][$i][0]);
      $w = $this->project['header'][$i][1];
      $a = isset($this->project['header'][$i][2]) ? strtoupper($this->project['header'][$i][2]) : 'L';
      $this->MultiCell($w, 3, $text, 0, $a);

      // Position der Spalten erfassen
      $this->colum[$i] = $step_x;

      // neue Position festlegen
      $step_x += $w;
      $this->SetXY( $step_x, $old_y );
	
    }
    $this->Ln(10);

    $step_x = $old_x = $this->GetX();
    $step_y = $old_y = $this->GetY();

    // Spalten-Content
    for ( $z = 0; $z < count($this->project['entry']); $z++ ) {

      if ( $this->global['layout']['show_pos_num'] == 1 ) {
        $this->MultiCell($pos_w, 5, 1 + $z, 0, 'C');
			  $step_x += $pos_w;
			  $this->SetXY($step_x,$step_y);
			}

			$ya = Array();

      for ( $s = 0; $s < count($this->project['entry'][$z]); $s++ ) {

        $text = trim($this->project['entry'][$z][$s]);
        $w = $this->project['header'][$s][1];
        $a = isset($this->project['header'][$s][2]) ? strtoupper($this->project['header'][$s][2]) : 'L';
        $this->MultiCell($w, 5, $text, 0, $a);
		    $step_x += $w;
		    $ya[$s] = $this->GetY() - $step_y;
		    $this->SetXY($step_x,$step_y);

      }

      // print_r($ya);
      
      $step_x = $old_x;
      $step_y += max($ya);
      $this->SetXY( $step_x, $step_y );
      
    }
    $this->Ln(10);

    // Endsummen
    $xl = $pos_w + $this->GetX();
    $xr = $this->colum[ count($this->project['header'])-1 ];
    $wl = $this->project['header'][0][1];
    $wr = $this->project['header'][ count($this->project['header'])-1 ][1];

    // Nettobetrag    
 	  $this->SetX( $xl );
		$this->Cell($wl, 4, $this->global['lang']['text_total_netto'], 0, 0, 'L');
    $this->SetX( $xr ); 
		$this->Cell($wr, 4, $this->calculation['total_netto'], 0, 1, 'R');

    // MwSt
 	  $this->SetX( $xl );
		$this->Cell($wl, 4, $this->global['lang']['text_total_tax'], 0, 0, 'L');
    $this->SetX( $xr ); 
		$this->Cell($wr, 4, $this->calculation['total_tax'], 0, 1, 'R');

    // Endsumme
    $this->SetFont('','B','');
 	  $this->SetX( $xl );
		$this->Cell($wl, 4, $this->global['lang']['text_total_sum'], 0, 0, 'L');
    $this->SetX( $xr ); 
		$this->Cell($wr, 4, $this->calculation['total_sum'], 0, 1, 'R');


  }


  // color
  function fc($typ) {
    $c = explode(',', $this->global['color'][$typ] );
    $this->SetTextColor( $c[0], $c[1], $c[2] );
  }

  // Preisformatierung
  function FormPrice( $str ) {
		return number_format( $str, 
      (int)$this->global['money']['format_decimal'], 
      $this->global['money']['format_dec_point'], 
      $this->global['money']['format_thousands_sep']
      );
	}

  // Ende der Seite testen
  function TestEndPage() {
    if ( $this->GetY() > ($this->h - 30) ) { 
      $this->AddPage(); 
      $this->SetY( $this->tMargin ); 
      
    }
  }
  
// class end
}
?>
