<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml"><head>
<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1">
<!--Yahoo! User Interface Library: http://twiki.corp.yahoo.com/view/Devel/PresentationPlatform--><!--Begin YUI CSS infrastructure, including Standard Reset, Standard Fonts, and CSS Page Grids -->
<link rel="stylesheet" type="text/css" href="../../build/fonts/fonts.css">
<link rel="stylesheet" type="text/css" href="../../build/grids/grids.css"><!--end YUI CSS infrastructure--><!--begin YUIL Utilities -->
<link rel="stylesheet" type="text/css" href="css/code.css">
<link rel="stylesheet" type="text/css" href="css/local/tree.css">
<script src="../../build/yahoo/yahoo-min.js"></script>
<script src="../../build/event/event-min.js"></script>
<script src = "../../build/connection/connection-min.js" ></script>
<script src="../../build/treeview/treeview.js"></script>
<script>
var tree;

/* AJAX  */
var handleSuccess = function(o) {
	if(o.responseText !== undefined) {
		var node, subfolder = o.responseText.split(';');
		/*
			subfolder[0] = path
			subfolder[1] = id
			subfolder[2-n] = folders
		*/

		if(subfolder[1] == 0) {
			node = tree.getRoot();
		} else 
			node = tree.getNodeByIndex(subfolder[1]);

		for(var i=2; i<subfolder.length; i++) {
			new YAHOO.widget.TextNode(subfolder[i], node, false);
		}
		tree.draw();
	}
}

var handleFailure = function(o) {
	alert('error');
}

var callback =
{
	success:handleSuccess,
	failure:handleFailure,
	argument: { param:'param' }
};

function folderTree(index) {
	var path = '';
	if(index > 0) {
		var par = tree.getNodeByIndex(index);
		do {
			path = par.label+"/"+path;
			par = par.parent;
		} while(par.parent != null);
	}
	var request = YAHOO.util.Connect.asyncRequest('POST', 'folder.php', callback, 'path='+path+'&index='+index); 
}


/*create namespace for examples:*/
YAHOO.namespace("example");

/* Using Crockford's "Module Pattern": */
YAHOO.example.treeExample = function() {

	var currentIconMode;

	function changeIconMode() {
	        var newVal = parseInt(this.value);
	        if (newVal != currentIconMode) {
	            currentIconMode = newVal;
	        }
	        buildTree();
	}

	function loadNodeData(node, fnLoadComplete) {
		//callback with XMLHttpRequest
		//for more data.
		folderTree(node.index);
		
		//When we're done creating child nodes, we execute the node's
		//loadComplete callback method which comes in as our loader's
		//second argument (we could also access it at node.loadComplete,
		//if necessary):
		fnLoadComplete();
		tree.draw();
	}

        function buildTree() {
		   //create a new tree:
		   tree = new YAHOO.widget.TreeView("treeContainer");
		   
		   //turn dynamic loading on for entire tree:
		   tree.setDynamicLoad(loadNodeData, currentIconMode);
		   
		   folderTree(0);
		   
		   //render tree with these root nodes; all descendants of these nodes
		   //will be generated as needed by the dynamic loader.
		   tree.draw();
		}


	return {
		init: function() {
			YAHOO.util.Event.on(["mode0", "mode1"], "click", changeIconMode);
			var el = document.getElementById("mode1");
			if (el && el.checked) {
				currentIconMode = parseInt(el.value);
			} else {
				currentIconMode = 0;
			}
			buildTree();
	        }
	}
} ();

YAHOO.util.Event.addListener(window, "load", YAHOO.example.treeExample.init, YAHOO.example.treeExample,true)
</script>
<title>Dynamic TreeView Example</title>
</head>
<body id="yahoo">
        <!-- start: secondary column from outer template -->
        <div id="treeContainer"></div>
        <!-- end: secondary column from outer template -->
</body></html>
